<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class ControllerCmshelper extends BaseController
{
    public function init(){
        parent::init();
      
        PageContext::addScript("login.js");
 
		$this->_common	 		= new ModelCommon();
                $this->_session         = new LibSession();
                PageContext::$response->settings = Apputils::loadSettings();
                
               
     }

     //Function to load social publishing widget
    public function socialpublishing($locationId){
        PageContext::$response->socialShareEnabled = Apputils::fetchSettings('social_share_enable');
        PageContext::$response->facebbokId = Apputils::fetchSettings('fb_app_id');
        PageContext::$response->locationId  = $locationId;
        PageContext::$response->location  = Location::getLocationName($locationId);
        
        PageContext::addStyle("accordion_style.css");
        PageContext::addStyle("dash_board.css");
       //  PageContext::addScript("treeMenu.js");
        PageContext::addPostAction("socialpublishing", "cmshelper", "default");
        PageContext::renderPostAction("socialpublishing", "cmshelper", "default");
       exit;
    }

    public function socialcontent($locationId) {
       
        PageContext::$response->locationDetails = Cmshelper::fetchLocationDetails($locationId);

        $callback = '';
        if (isset($_GET['callback'])) {
            $callback = filter_var($_GET['callback'], FILTER_SANITIZE_STRING);
        }

       $result = PageContext::$response->locationDetails;
       $imageFile = $result->file_id!=0?(file_exists(FILE_UPLOAD_DIR.'/'.Apputils::fetchFileName($result->file_id))?BANNER_READ_URL.Apputils::fetchFileName($result->file_id):IMAGE_MAIN_URL.'no_image.png'):IMAGE_MAIN_URL.'no_image.png';
       $logoFile = BASE_URL."project/themes/".CURRENT_THEME."/".'images/logo-footer.png';
            $locationDetails .= '<div id="jqResults"><ul id="jqResultRow">
            <li>
                <div class="result-display">';

       if($result->file_id!=0 && file_exists(FILE_UPLOAD_DIR.'/'.Apputils::fetchFileName($result->file_id)))
            $locationDetails .='<a href="'. BASE_URL."location/".$result->nLocation_Id.'"><img src="'.$imageFile.'" alt="" ></a>';

       $locationDetails .=  '<p>'. trim($result->vLocation_Description).' ..'.'</p>
                       <div class="clear"></div>
                </div>
            </li>
        <div id="moreClass"></div>
        </ul></div>';
       
        $data = '<link rel="stylesheet" href="'.BASE_URL."/project/themes/".CURRENT_THEME.'/css/results.css" type="text/css" media="screen" title="default" />';
        $data .= '<link rel="stylesheet" href="'.BASE_URL.'project/styles/socialpublishmodule.css" type="text/css" media="screen" title="default" />';

        
        $data .= '<div class="widget_wrapper">
		<div class="widget_header">
			<div class="instructor">

				<a href="'.BASE_URL."location/".$result->nLocation_Id.'" ><p>'.PageContext::$response->locationDetails->vLocation_Name.'</p></a>
			</div>
			<div class="clear"></div>
		</div>
		<div class="widget_content">
			<ul> '.$locationDetails.'</ul>
		</div>
		<div class="widget_footer">
			<a href="'.BASE_URL.'" target="_blank"><img src="'.$logoFile.'"></a>
			<div class="clear"></div>
		</div>
		<div class="clear"></div>
	</div>';


        echo $callback . '('.json_encode(array('data'=>$data)).')';
        exit();
    }
    
    //Function to load reserved rooms
    public function reservedrooms(){

        PageContext::addScript("cmshelper.js");
        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];
        
        $searchCriteria['location'] = PageContext::$request['location'];
        $searchCriteria['date'] = PageContext::$request['date'];
        PageContext::$response->locations = Cmshelper::getLocationsHavingAccomodation();
        $sectionData = Cmshelper::fetchReservedRooms($searchCriteria);
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
        PageContext::addJsVar("totalResulPages", $pageDetails[0]);
        PageContext::$response->resultPageCount =   $pageDetails[0];
       
     
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .=  "&";
        
        if($searchCriteria['searchText'] != '')
            $pageUrl .= "&searchTextCustom=".$searchCriteria['searchText']."&searchFieldCustom=".$searchCriteria['searchField'].'&';
        
        if(!empty($searchCriteria['date']))
            $pageUrl .= "&date=".$searchCriteria['date']."&";
        
        if(!empty($searchCriteria['location']))
            $pageUrl .= "&location=".$searchCriteria['location'].'&';
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2],PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = Cmshelper::fetchReservedRooms($searchCriteria, $pageDetails[1]);
    }
    
    
    //Funtion to load blocked rooms
    public function blockedrooms(){

        PageContext::addScript('cmshelper.js');
      
        
        
        PageContext::$response->destinations = Cmshelper::getDestinationsHavingAccomodation();
        PageContext::$response->locations = Cmshelper::getLocationsHavingAccomodation();
        if(PageContext::$request['section_action'] == 'block_room')
            PageContext::$response->showAddForm = TRUE;
        else if(PageContext::$request['section_action'] == 'delete'){

            $allotmentId = PageContext::$request['allotmentId'];
            $deleteBlockedProperty  = Cmshelper::deleteBlockedRooms($allotmentId);
            /*
            $requestArray ['location'] = PageContext::$request['location'];
            $requestArray['selectedAccomodationType'] = PageContext::$request['accomodation'];
            Cmshelper::unblockRooms($requestArray);
            */
            PageContext::$response->message = "Rooms unblocked Successfully";
            PageContext::$response->messageClass = 'alert-success';
        }
        
          if(isset(PageContext::$request['blockRoom'])){
            Logger::info(PageContext::$request);
            $requestArray ['destination'] = PageContext::$request['destination'];
            $requestArray ['location'] = PageContext::$request['location'];
            $requestArray ['date'] = PageContext::$request['jqDate'];
            $requestArray ['numberofdays'] = PageContext::$request['numOfDays'];
            $requestArray ['selectedAccomodationTypes'] = implode(",",PageContext::$request['accomodationTypes']);
            $requestArray ['selectedRoomCounts'] = $_POST['roomTotal'];
            
            $blockedPropertyExists  = Cmshelper::checkBlockedPropertyExists($requestArray);
            if($blockedPropertyExists->allotCount > 0) {
                PageContext::$response->accomodationTypes = Cmshelper::getAccomodationTypesByLocation($requestArray ['location']);
                PageContext::$response->errorMessage = 'This location is already booked/blocked';
                PageContext::$response->messageClass = 'alert-error';

            }
            if(PageContext::$response->errorMessage=="") {
                Cmshelper::blockRooms($requestArray);
                PageContext::$response->message = "Rooms blocked Successfully";
                PageContext::$response->messageClass = 'alert-success';
                PageContext::$response->showAddForm = false;
            }
           
        }
        
        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];
         
        $sectionData = Cmshelper::fetcBlockedRooms($searchCriteria);
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'],  PageContext::$request['page']);
        PageContext::addJsVar("totalResulPages", $pageDetails[0]);
        PageContext::$response->resultPageCount =   $pageDetails[0];
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        $pageUrl .= "&";
        
        if($searchCriteria['searchText'] != '')
            $pageUrl .= "&searchTextCustom=".$searchCriteria['searchText']."&searchFieldCustom=".$searchCriteria['searchField'].'&';
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2],PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = Cmshelper::fetcBlockedRooms($searchCriteria, $pageDetails[1]);
    }
    
    
    //Function to load locations[ajax]
    public function loadlocations($destinationId){
        
      //  $destinationId = PageContext::$request['destination'];
         $locations = Cmshelper::fetchLocationsByDestination($destinationId);
         
             PageContext::$response->locations = $locations;
            $dropDown =' <select name="location" id="jqlocationId" class="priorityField">
                         <option value="">Select</option>';
            foreach($locations as $location)
                $dropDown .='<option value="'.$location->nLocation_Id.'">'.$location->vLocation_Name.'</option>';
            $dropDown .='</select>     ';
       
    
         echo $dropDown;
         exit;
         
        PageContext::addPostAction("loadlocations", "cmshelper", "deafult");
        PageContext::renderPostAction("loadlocations", "cmshelper", "deafult");
       //exit;
    }
    
    
    //Function to load accomodation types drop down [ajax]
    public function loadAccomodationTypesDropDown($locationId){
        
         $locations = Cmshelper::getAccomodationTypesByLocation($locationId);
         
             
        $dropDown ='<select name="accomodation" id="jqAccomodationId" class="priorityField">
                         <option value="">Select</option>';
        foreach($locations as $location)
            $dropDown .='<option value="'.$location->value.'">'.$location->text.'</option>';
        
        $dropDown .='</select>';
    
         echo $dropDown;
         exit;
         
        
       //exit;
    }
    
    //Function to load accomodation types checkbox[ajax]
    public function loadaccomodationtypes($locationId){
        $accomodationTypes = Cmshelper::getAccomodationTypesByLocation($locationId);
        
       
        $dropDown .='<table>';
        
        foreach($accomodationTypes as $accomodationType){
             $rooms =   Cmshelper::getAvailRoomsByAccomodation($accomodationType->value,$locationId); 
            $dropDown .='<tr><td><input type="checkbox" value="'.$accomodationType->value.'" name="accomodationTypes[]" id="accomodationTypes" class="jqAccomodation"></td><td>&nbsp;'.$accomodationType->text.'</td></tr>';
         
          if ($rooms >0){
          $select ='<tr><td>Rooms</td><td><select id="roomCount-'.$accomodationType->value.'">';
           for($i=1 ; $i<=$rooms; $i++)
                $select.= '<option value="'.$i.'">'.$i.'</option>';
           $select.='</select></td></tr>';
           
          }
          $dropDown.=$select;
        }
       
    $dropDown.='</table>';
         echo $dropDown;
         exit;
    }
    
       
    //Function to load group discount
     public function groupdiscount(){
        
        if(isset(PageContext::$request['blockRoom'])){
            Logger::info(PageContext::$request);
            $requestArray ['destination'] = PageContext::$request['destination'];
            $requestArray ['location'] = PageContext::$request['location'];
            $requestArray ['startRange'] = PageContext::$request['jqStartRange'];
            $requestArray ['endRange'] = PageContext::$request['jqEndRange'];
            $requestArray ['discountPercentage'] = PageContext::$request['discountPercentage'];
            $requestArray ['selectedAccomodationTypes'] = implode(",",PageContext::$request['accomodationTypes']);
            Cmshelper::addGroupDiscount($requestArray);
            PageContext::$response->message = "Discount Added Successfully";
        }
        
        PageContext::addScript('cmshelper.js');
        PageContext::$response->destinations = Cmshelper::getDestinationsHavingAccomodation();
        PageContext::$response->locations = Cmshelper::getLocationsHavingAccomodation();
        
        if(PageContext::$request['section_action'] == 'add_offer')
            PageContext::$response->showAddForm = TRUE;
        else if(PageContext::$request['section_action'] == 'delete'){
            $requestArray ['location'] = PageContext::$request['location'];
            $requestArray['selectedAccomodationType'] = PageContext::$request['accomodation'];
            Cmshelper::removeGroupDiscount($requestArray);
            PageContext::$response->message = "Discount Removed Successfully";
        }
        
        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];
         
        $sectionData = Cmshelper::fetchGroupDiscount($searchCriteria);
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
        PageContext::addJsVar("totalResulPages", $pageDetails[0]);
        PageContext::$response->resultPageCount =   $pageDetails[0];
       
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .= "&";
        
        if($searchCriteria['searchText'] != '')
            $pageUrl .= "&searchTextCustom=".$searchCriteria['searchText']."&searchFieldCustom=".$searchCriteria['searchField'].'&';
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2],PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = Cmshelper::fetchGroupDiscount($searchCriteria, $pageDetails[1]);
    }
    
    //Fucntion to load payments
    public function payments()
    {
       
        
        PageContext::$response->section_config->report = TRUE;
        PageContext::addScript('cmshelper.js');

        if(isset(PageContext::$request['settlePayments']))
        {
            Logger::info(PageContext::$request);
            $requestArray ['refNumber']           = PageContext::$request['refNumber'];
            $requestArray ['payType']             = PageContext::$request['payType'];
            $requestArray ['amount']              = PageContext::$request['amount'];
            $requestArray ['payId']               = PageContext::$request['referId'];


            Cmshelper::settleBookingPayments($requestArray);
            PageContext::$response->message = "Payment Settled Successfully";
            
        }
        else if(isset(PageContext::$request['capturePayments']))
        {
           
            $requestArray ['amount']              = PageContext::$request['amount'];
            $requestArray ['transactionId']       = PageContext::$request['transactionId'];
            $captureStatus                        = Payments::docaptureFromAuthorizeNet($requestArray);
            
            if($captureStatus['status'])
            {
                Cmshelper::updateCaptureStatus(PageContext::$request['referId']);
                PageContext::$response->message   = "Payment captured Successfully";
            }
            else
            {
                PageContext::$response->errorMessage = $captureStatus['message'];                
            }
            
        }
        
        //Fetch search criteria if exists
        $searchCriteria['searchField']                     = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText']                      = PageContext::$request['searchTextCustom'];



         if(PageContext::$request['section_action'] == 'settle')
         {
            PageContext::$response->bankDetails            = Cmshelper::fetchBankDetails(PageContext::$request['ref']);
            PageContext::$response->referId                = PageContext::$request['ref'];
            PageContext::$response->showAddForm            = TRUE;
            PageContext::$response->amount                 = PageContext::$request['amount'];
         }
         else if(PageContext::$request['section_action'] == 'capture')
         {
            PageContext::$response->showCaptureForm        = TRUE;
            PageContext::$response->referId                = PageContext::$request['ref'];
            PageContext::$response->amount                 = PageContext::$request['amount'];
            PageContext::$response->transactionId          = PageContext::$request['transactionId'];
         }

        $sectionData = Cmshelper::fetchPayments($searchCriteria);
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);


        PageContext::addJsVar("totalResulPages", $pageDetails[0]);
        PageContext::$response->resultPageCount           = $pageDetails[0];
       
        
        $listDataResults = Cmshelper::fetchPayments($searchCriteria, $pageDetails[1]);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .= "&";
        
        if($searchCriteria['searchText'] != '')
           $pageUrl .= "&searchTextCustom=".$searchCriteria['searchText']."&searchFieldCustom=".$searchCriteria['searchField'].'&';
         
        PageContext::addJsVar("currentURL", $pageUrl);
        
        PageContext::$response->currentURL                 = $pageUrl;
        PageContext::$response->pagination                 = Cms::pagination($pageDetails[2], PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents               = $listDataResults;

        
    }
    
    //Function to load cancelled payments
    public function cancelledpayments(){
       
        PageContext::$response->section_config->report = TRUE;
        PageContext::addScript('cmshelper.js');
        
        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];
        if(PageContext::$request['section_action'] == 'settle')
        {
            PageContext::$response->bankDetails = Cmshelper::fetchBankDetails(PageContext::$request['ref']);
            PageContext::$response->referId = PageContext::$request['ref'];
            PageContext::$response->showAddForm = TRUE;
            PageContext::$response->amount = PageContext::$request['amount'];
        }
        
        if(isset(PageContext::$request['settlePayments']))
        {
            Logger::info(PageContext::$request);
            
            $requestArray ['refNumber'] = PageContext::$request['refNumber'];
            $requestArray ['payType'] = PageContext::$request['payType'];
            $requestArray ['amount'] = PageContext::$request['amount'];
            $requestArray ['payId'] = PageContext::$request['referId'];
            Cmshelper::settleCancelletionPayments($requestArray);
            PageContext::$response->message = "Cancelled Payment Settled Successfully";
            
        }
        
        $sectionData = Cmshelper::fetchCancelledPayments($searchCriteria); //echopre($sectionData);
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
        PageContext::addJsVar("totalResulPages", $pageDetails[0]);
        PageContext::$response->resultPageCount =   $pageDetails[0];
       
        
        $listDataResults = Cmshelper::fetchCancelledPayments($searchCriteria, $pageDetails[1]);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .= "&";
        
         if($searchCriteria['searchText'] != '')
            $pageUrl .= "&searchTextCustom=".$searchCriteria['searchText']."&searchFieldCustom=".$searchCriteria['searchField'].'&';
         
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2], PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;


         


    }
    
    public function referrals(){


        PageContext::$response->userAffiliateData = $userAffiliateData = Cmshelper::getUserAfiliateData(PageContext::$request['referId'],PageContext::$request['userId']);
        if(isset(PageContext::$request['settlePayments'])){ 
            Logger::info(PageContext::$request); 
            $requestArray ['refNumber'] = PageContext::$request['refNumber'];
            $requestArray ['payType'] = PageContext::$request['payType'];
            $requestArray ['amount'] = PageContext::$request['amount'];
            $requestArray ['referId'] = PageContext::$request['referId'];
            $requestArray ['userId'] = PageContext::$request['userId'];
            Cmshelper::settlePayments($requestArray);
            PageContext::$response->message = "Referral Payment Settled Successfully";
        }
        
        PageContext::addScript('cmshelper.js');
       
        
        if(PageContext::$request['section_action'] == 'settle'){
            PageContext::$response->referId = PageContext::$request['ref'];
            PageContext::$response->showAddForm = TRUE;
            PageContext::$response->amount = PageContext::$request['amount'];
        }
        
        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];
         
        $sectionData = Cmshelper::fetchReferrals($searchCriteria); 
        $numRowsListData = count($sectionData);
        
        $perPageSize  =   PageContext::$response->cmsSettings['admin_page_count'];
        $totalResulPages = ceil($numRowsListData/$perPageSize);
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;
       
        $page = PageContext::$request['page'];

        if($page=="")
            $page=1;

        $startPage=($page-1)*$perPageSize;
        $limit="LIMIT $startPage,$perPageSize";
        $listDataResults = Cmshelper::fetchReferrals($searchCriteria, $limit); //echopre($listDataResults);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
            $pageUrl = $pageUrl."&";
        }
        else
            $pageUrl=$pageUrl."&";
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($numRowsListData,$perPageSize,$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }


    public function referralsBkp(){

        if(isset(PageContext::$request['settlePayments'])){
            Logger::info(PageContext::$request);
            $requestArray ['refNumber'] = PageContext::$request['refNumber'];
            $requestArray ['payType'] = PageContext::$request['payType'];
            $requestArray ['amount'] = PageContext::$request['amount'];
            $requestArray ['referId'] = PageContext::$request['referId'];
            Cmshelper::settlePayments($requestArray);
            PageContext::$response->message = "Referral Payment Settled Successfully";
        }

        PageContext::addScript('cmshelper.js');


        if(PageContext::$request['section_action'] == 'settle'){
            PageContext::$response->referId = PageContext::$request['ref'];
            PageContext::$response->showAddForm = TRUE;
            PageContext::$response->amount = PageContext::$request['amount'];
        }

        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];

        $sectionData = Cmshelper::fetchReferrals($searchCriteria);
        $numRowsListData = count($sectionData);

        $perPageSize  =   PageContext::$response->cmsSettings['admin_page_count'];
        $totalResulPages = ceil($numRowsListData/$perPageSize);
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;

        $page = PageContext::$request['page'];

        if($page=="")
            $page=1;

        $startPage=($page-1)*$perPageSize;
        $limit="LIMIT $startPage,$perPageSize";
        $listDataResults = Cmshelper::fetchReferrals($searchCriteria, $limit);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);

        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
            $pageUrl = $pageUrl."&";
        }
        else
            $pageUrl=$pageUrl."&";
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($numRowsListData,$perPageSize,$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }
    
    
 public function settingsdisplay() {
 	
        PageContext::includePath('resize');
        PageContext::addScript("settingsdisplay.js");      
        PageContext::addStyle("cmssettings.css");              
        $message = "";
        $success = "success";
        //$enableChecks = array('bookmark_enable','recaptcha_enable','calendar_enable','social_share_enable', 'googleaddemo','feedname','GoogleMap','expedia_enable','referral');
        $enableChecks = array('recaptcha_enable','calendar_enable', 'googleaddemo','GoogleMap');
        $enablePaymentChecks = array('cenable_paypal','vpaypal_test_mode','cenable_authorize','vauthorize_test_mode','enablegoogle','enableyourpay','enable_other_payments','enableworldpay','enablebluepay','cenable_paypal_pro','vpaypal_pro_test_mode');
        $enableAdvancedSettingsChecks = array('AllowCancel','EnableSMTP','SSLEnabled','referral');
        $enableSocialSettingChecks = array('enable_fb', 'enable_twitter','enable_ln','bookmark_enable','feedname','social_share_enable');
        $enableExpediaChecks = array('expedia_enable');
       
        // General settings updation
        if(isset($_POST['submitBtn'])){
            if(is_uploaded_file($_FILES['sitelogo']['tmp_name'])) {  
                $bannerParts = pathinfo($_FILES['sitelogo']['name']);               
                if(move_uploaded_file($_FILES['sitelogo']['tmp_name'], BASE_PATH.'project/styles/images/'.$_FILES['sitelogo']['name'])) {
                  /*  $resizeObj = new resize($bannerOriginal);
                    $resizeObj->resizeImage(283, 67, 'exact');
                    $rz=preg_replace("/\.([a-zA-Z]{3,4})$/","_disp.gif",$bannerOriginal);
                    $resizeObj->saveImage($rz, 100);
                    Cmshelper::updateFooterLogo($rz);*/
                    try {
                     Cmshelper::createThumbnail($_FILES['sitelogo']['name'],'',true,283,67,IMAGE_ROOT_URL);
                     Cmshelper::createThumbnail($_FILES['sitelogo']['name'],'footer_',true,157,36,IMAGE_ROOT_URL);
                    } catch (Exception $exc) {

                    }
                    $_POST['sitelogo'] = $_FILES['sitelogo']['name'];
                    @unlink($bannerOriginal);
                }
            }
            
            foreach($enableChecks as $checkBoxes){
                if($_POST[$checkBoxes] == '') 
                    $_POST[$checkBoxes] = 'N';
            }

            // Update all admin mails
            if($_POST['vadmin_email']!=""){
                $_POST['addressfromemail'] =  $_POST['addressfromemailname']= $_POST['addressreplyemail']= $_POST['addressreplyemailname']= $_POST['vadmin_email'];
            }

            Cmshelper::updateSettings($_POST);

            $message = "Settings updated successfully.";
            $success = "success";
        }
        // update expedia settings
        if(isset($_POST['submitExpediaBtn']))
        {
            foreach($enableExpediaChecks as $checkBoxes){
                if($_POST[$checkBoxes] == '') 
                    $_POST[$checkBoxes] = 'N';
            }
            Cmshelper::updateSettings($_POST);
            $message = "Expedia Settings updated successfully.";
            $success = "success";
        }
        // update social & seo settings
        if(isset($_POST['submitSocialBtn']))
        {
            foreach($enableSocialSettingChecks as $checkBoxes){
                if($_POST[$checkBoxes] == '') 
                    $_POST[$checkBoxes] = 'N';
            }
            Cmshelper::updateSettings($_POST);
            $message = "Social Settings updated successfully.";
            $success = "success";
        }
        if(isset($_POST['submitEmbedBtn']))
        {
           Cmshelper::updateSettings($_POST);
           ?><script>
$('#htmlGeneratedPreview').load('http://localhost/reservelogic/cms?section=settings  #htmlGeneratedPreview').delay(1000);
</script>
<?php
        }

        // Payment section update
        if(isset($_POST['paymentSubmitBtn'])){ 
        	
            //PEM File updation
            if(is_uploaded_file($_FILES['pemfolder']['tmp_name'])) {
                $pemPath = BASE_PATH.'project/lib/paymentgateways/yourpay/pem/'.$_FILES['pemfolder']['name'];
                if(move_uploaded_file($_FILES['pemfolder']['tmp_name'], $pemPath)) {
                     $_POST['pemfolder'] = $_FILES['pemfolder']['name'];                          
                }  
            }
        	
            foreach($enablePaymentChecks as $checkBoxes){
                if($_POST[$checkBoxes] == '') 
                    $_POST[$checkBoxes] = 'N';     
            }  
             //if($_POST['cenable_paypal']=='N' && $_POST['cenable_authorize']=='N' && $_POST['enablegoogle']=='N'  ){
//            if($_POST['enableworldpay']=='N' && $_POST['cenable_authorize']=='N' && $_POST['enableyourpay']=='N' 
//                    && $_POST['cenable_paypal_pro']=='N' && $_POST['enablebluepay']=='N' ){
//                $message = "Please enable atleast one payment method.";
//                $success = "error";
//            }else{
                
                Cmshelper::updateSettings($_POST,$_POST['paymentEnabled']);
                $message = "Payment Settings updated successfully.";
                $success = "success";
            //}
        }
 
       

        // advacned settings updation
        if(isset($_POST["domainSubmitBtn"])) {

            foreach($enableAdvancedSettingsChecks as $checkBoxes) {
                if($_POST[$checkBoxes] == '')
                $_POST[$checkBoxes] = 'N';
            }  
            Cmshelper::updateSettings($_POST);
            $message = "Advanced Settings updated successfully.";
            $success = "success";
        }
       
        
        if(isset($_POST['passwordSubmitBtn'])){

            if(trim($_SESSION['admin_type']) != '')
            $admin_uid 		= $_SESSION['admin_type'];  // cms doesnt support uid as of now
            else if(trim($_SESSION['cms_admin_type']) != '')
            $admin_uid 		= $_SESSION['cms_admin_type'];  // cms doesnt support uid as of now

            $adminUserName = $_SESSION['cms_cms_username'];

            $updatePassword = Cmshelper::updateAdminPassword($adminUserName, $_POST);
            if($updatePassword=='success'){
               $message 	= "Password updated successfully.";
                $success 	= "success";
            }else{
                $message 	= $updatePassword;
                $success 	= "error";
            }
        }
        
       
        //general settings
        $pageContents       = Cmshelper::getListItem("lookup", array('*'), array(array('field' => 'groupLabel' , 'value' => 'General')));
        $genSettings 		= array();
        foreach($pageContents as $items)
        	$genSettings[$items->vLookUp_Name] 	= $items; 
      	PageContext::$response->genSettings 	= $genSettings;
        
        //Embed Code settings
        $pageContents       = Cmshelper::getListItem("lookup", array('*'), array(array('field' => 'groupLabel' , 'value' => 'Embed Code')));
        $embedSettings 		= array();
        foreach($pageContents as $items)
        	$embedSettings[$items->vLookUp_Name] 	= $items; 
           // var_dump($embedSettings);exit;
      	PageContext::$response->embedSettings 	= $embedSettings;
        PageContext::$response->embedDivHtml 	= "<div id='".$embedSettings['embed_div_id']->vLookUp_Value."' ></div>";
      	 	
      	// payment settings  	
      	$paymentContents       	= Cmshelper::getListItem("lookup", array('*'), array(array('field' => 'groupLabel' , 'value' => 'Payment')));
      	$paySettings			= array();
      	foreach($paymentContents as $items)
      		$paySettings[$items->vLookUp_Name] 	= $items; 
      	PageContext::$response->paySettings 	= $paySettings;
      	   	
      	// advanced settings
      	$advancedContents       = Cmshelper::getListItem("lookup", array('*'), array(array('field' => 'groupLabel' , 'value' => 'Advanced')));
      	$advancedSettings		= array();
      	foreach($advancedContents as $items)
      		$advancedSettings[$items->vLookUp_Name] = $items; 
      	PageContext::$response->advancedSettings 	= $advancedSettings;

        // social settings
      	$socialContents       = Cmshelper::getListItem("lookup", array('*'), array(array('field' => 'groupLabel' , 'value' => 'Social Settings')));
      	$socialSettings		= array();
      	foreach($socialContents as $items)
      		$socialSettings[$items->vLookUp_Name] = $items;
      	PageContext::$response->socialSettings 	= $socialSettings;
        
        //expedia settings
        $expediaContents       = Cmshelper::getListItem("lookup", array('*'), array(array('field' => 'groupLabel' , 'value' => 'Expedia')));
        $expediaSettings		= array();
      	foreach($expediaContents as $items)
      		$expediaSettings[$items->vLookUp_Name] = $items;
        PageContext::$response->expediaSettings 	= $expediaSettings;
        
      	
        PageContext::$response->message 		= $message;
        PageContext::$response->successError 	= $success;
        
        
        PageContext::addPostAction("managepenalty","cmshelper", "default");
        PageContext::addPostAction("managenavigation","cmshelper", "default");
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
            $pageUrl = $pageUrl."&";
        }
        else
            $pageUrl=$pageUrl."&";
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
       
         if(PageContext::$request['action'] == 'add' || PageContext::$request['action'] == 'edit'){
            PageContext::$response->showAddForm = true;
            if(PageContext::$request['action'] == 'edit'){
                PageContext::$response->penaltyId = PageContext::$request['penaltyId'];
                PageContext::$response->penaltyDetails = Cmshelper::fetchPenaltyDetails(PageContext::$response->penaltyId);
            
                
            }
        }
        else if(PageContext::$request['action'] == 'addnav' || PageContext::$request['action'] == 'editnav'){
            PageContext::$response->showAddForm = true;
            if(PageContext::$request['action'] == 'editnav'){
                PageContext::$response->navigationId = PageContext::$request['navigationId'];
                PageContext::$response->navigationDetails = Cmshelper::fetchNavigationDetails(PageContext::$response->navigationId);
            
                
            }
        }
        
        else if(PageContext::$request['action'] == 'addpenalty'){
            $requestArray['day_start_range'] = PageContext::$request['daysStartRange'];
            $requestArray['day_end_range'] = PageContext::$request['daysEndRange'];
            $requestArray['vType'] = PageContext::$request['mode'];
            $requestArray['nAmount'] = PageContext::$request['amount'];
            $requestArray['vActive'] = PageContext::$request['status'];
            
            if(PageContext::$request['penaltyId']){
                Cmshelper::updatePenalty($requestArray,PageContext::$request['penaltyId'] );
                PageContext::$response->message = 'Penalty updated Successfully.';
            }else{
                Cmshelper::addPenalty($requestArray);
                PageContext::$response->message = 'Penalty added Successfully.';
            }
            
        }else if(PageContext::$request['action'] == 'removepenalty'){
            Cmshelper::removePenalty(PageContext::$request['penaltyId']);
            PageContext::$response->message = 'Penalty removed Successfully.';
        }
        else if(PageContext::$request['action'] == 'removenavigation'){
            Cmshelper::removeNavigation(PageContext::$request['navigationId']);
            PageContext::$response->message = 'Navigation removed Successfully.';
        }
        else if(PageContext::$request['action'] == 'addnavigation'){
            $requestArray['navigation'] = PageContext::$request['navigation'];
            $requestArray['label'] = PageContext::$request['label'];
            $requestArray['url'] = PageContext::$request['url'];
            
            if(PageContext::$request['navigationId']){
                Cmshelper::updateNavigation($requestArray,PageContext::$request['navigationId'] );
                PageContext::$response->message = 'Navigation updated Successfully.';
            }else{
                Cmshelper::addNavigation($requestArray);
                PageContext::$response->message = 'Navigation added Successfully.';
            }
        }
        
        //Penalties section 
        $sectionData = Cmshelper::fetchPenalties();
        $numRowsListData = count($sectionData);
        
        $perPageSize  =   PageContext::$response->cmsSettings['admin_page_count'];
        $totalResulPages = ceil($numRowsListData/$perPageSize);
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;
       
        $page = PageContext::$request['page'];

        if($page=="")
            $page=1;

        $startPage=($page-1)*$perPageSize;
        $limit="LIMIT $startPage,$perPageSize";
        $listDataResults = Cmshelper::fetchPenalties($limit);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
            $pageUrl=$pageUrl."&tab=penalty&page=".$page."&";
        }
        else
            $pageUrl=$pageUrl."&tab=penalty&page=".$page."&";
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($numRowsListData,$perPageSize,$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
        
        //Navigation section 
        $sectionData = Cmshelper::fetchNavigation();
        $numRowsListData = count($sectionData);
        
        $perPageSize  =   PageContext::$response->cmsSettings['admin_page_count'];
        $totalResulPages = ceil($numRowsListData/$perPageSize);
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;
       
        $page = PageContext::$request['page'];

        if($page=="")
            $page=1;

        $startPage=($page-1)*$perPageSize;
        $limit="LIMIT $startPage,$perPageSize";
        $listDataResults = Cmshelper::fetchNavigation($limit);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
            $pageUrl=$pageUrl."&tab=navigation&page=".$page."&";
        }
        else
            $pageUrl=$pageUrl."&tab=navigation&page=".$page."&";
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($numRowsListData,$perPageSize,$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents1    = $listDataResults;
        
        
        
    }

    public static function locationbasedaccomodationsseasonalrates() {
        $accomodationId         = intval(PageContext::$request['parent_id']);
        PageContext::$response->selectedAccomodationId = $accomodationId?trim($accomodationId):trim(PageContext::$request['parent_id']);

        if(isset(PageContext::$request['addSeasonalRate'])) { 
            $requestArray ['accomodationId']     = PageContext::$request['parent_id'];
            $requestArray ['rates']              = implode(',', PageContext::$request['txtAmountSeasonal']);
            $requestArray ['start_date']         = PageContext::$request['startDate'];
            $requestArray ['start_date']         = date("Y-m-d", strtotime(PageContext::$request['startDate']));
            $requestArray ['end_date']           = date("Y-m-d", strtotime(PageContext::$request['endDate']));
            //Logger::info($_FILES);

            if(PageContext::$request['availableAccomodationId'] == NULL)
            {
                Cmshelper::addseasonalRate($requestArray);
                PageContext::$response->message = "Seasonal Rate Added Successfully";
            }
            else
            {
                Cmshelper::updateseasonalRate($requestArray, PageContext::$request['availableAccomodationId']);
                PageContext::$response->message = "Accomodation Updated Successfully";
            }
        }

        if(PageContext::$request['section_action'] == 'add_seasonal_rate'||PageContext::$request['section_action'] == 'edit_accomodation'){
            PageContext::$response->showAddForm = TRUE;
            PageContext::$response->seasonal_id =  PageContext::$request['seasonal'];
            if(PageContext::$request['section_action'] == 'edit_accomodation')
                PageContext::$response->accomodationTypes = Cmshelper::getAllAccomodationTypes ();
        }
        else if(PageContext::$request['section_action'] == 'delete'){
            $requestArray['seasonal_id'] = PageContext::$request['seasonal'];
            Cmshelper::removeSeasonalRate($requestArray);
            PageContext::$response->message = "Accomodation Removed Successfully";
        }

        $db                     = new Db();
        $searchCriteriaQuery    = " C.accomodationId='".$accomodationId ."'";
        $listDataResults        = $db->selectResult("accomodation_seasonal_rates C ", "C.*", "  $searchCriteriaQuery");
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .= "&";
        PageContext::addScript('cmshelper.js');
        PageContext::addJsVar("currentURL", $pageUrl);
        
        PageContext::$response->currentURL = $pageUrl;
        $locationDat = Location::getLocationDetails($locationId); 
        PageContext::$response->accomodationName = $locationDat->vLocation_Name;
        PageContext::$response->pageContents    = $listDataResults;
        /*print_r($payments);
        die('****');*/
    }
    
   //Function to load location based accomodation
    public static function locationbasedaccomodations()
    {
        $locationId                                = intval(PageContext::$request['parent_id']);
        PageContext::$response->selectedLocationId = $locationId?trim($locationId):trim(PageContext::$request['locationId']);
        
         if(isset(PageContext::$request['addAccomodation']))
         {
             
                //print_r(PageContext::$request);die('***');

                $requestArray ['vCode']              = PageContext::$request['roomCode'];
                $requestArray ['nAt_Id']             = PageContext::$request['accomodationType'];
                $requestArray ['nAdults']            = PageContext::$request['adultsCount'];
                $requestArray ['additional_guest_allowed']   = intval(PageContext::$request['additional_guest_allowed']);
                $requestArray ['additional_guest_rate']      = PageContext::$request['additional_guest_rate'];
                $requestArray ['nChildren']          = PageContext::$request['childrenCount'];
                $requestArray ['nAmount']            = implode(",",PageContext::$request['txtAmount']);

                $requestArray['nRoom']               =  PageContext::$request['roomCount'];
                $requestArray['vActive']             = PageContext::$request['status'];

                Logger::info($_FILES);

                if($_FILES['file_id']['tmp_name']!="")
                {
                    $fileHandler                     = new Filehandler();
                    $fileDetails                     = $fileHandler->handleUpload($_FILES['file_id']);

                    Logger::info($fileDetails);

                    $requestArray['file_id']        = $fileDetails->file_id;
                }

                if(PageContext::$request['availableAccomodationId'] == NULL)
                {
                    $requestArray['nLocation_Id']   = PageContext::$request['locationId'];
                    Cmshelper::addAccomodationToLocation($requestArray);
                    PageContext::$response->message = "Accomodation Added Successfully";
                }
                else
                {
                    //print_r($requestArray);die;
                    Cmshelper::updateAccomodation($requestArray, PageContext::$request['availableAccomodationId']);
                    PageContext::$response->message = "Accomodation Updated Successfully";
                }
            
        }
        
        PageContext::addScript('cmshelper.js');
      
        PageContext::$response->accomodationTypes =  Cmshelper::getAccomodationTypesNotInLocation($locationId);
        if(PageContext::$request['section_action'] == 'add_accomodation'||PageContext::$request['section_action'] == 'edit_accomodation'){
            PageContext::$response->showAddForm = TRUE;
            PageContext::$response->nAat_Id =  PageContext::$request['accomodation'];
            if(PageContext::$request['section_action'] == 'edit_accomodation')
                PageContext::$response->accomodationTypes = Cmshelper::getAllAccomodationTypes ();
        }else if(PageContext::$request['section_action'] == 'delete'){
  
            $requestArray['selectedAccomodationType'] = PageContext::$request['accomodation'];
            $requestArray['locationId'] = PageContext::$request['locationId'];
            PageContext::$response->selectedLocationId = PageContext::$request['locationId'];
            Cmshelper::removeAccomodationFromLocation($requestArray);
            PageContext::$response->message = "Accomodation Removed Successfully";
            PageContext::$response->accomodationTypes = Cmshelper::getAllAccomodationTypes ();
        }
        
        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];
         
        $sectionData = Cmshelper::fetchLocationBasedAccomodations($locationId, $searchCriteria);
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
       
        PageContext::addJsVar("totalResulPages", $pageDetails[0]);
        PageContext::$response->resultPageCount =  $pageDetails[0];
       
        $listDataResults = Cmshelper::fetchLocationBasedAccomodations($locationId, $searchCriteria, $pageDetails[1]);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        $pageUrl .= "&";
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2],PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        $locationDat = Location::getLocationDetails($locationId); 
        PageContext::$response->locationName = $locationDat->vLocation_Name;
        PageContext::$response->pageContents    = $listDataResults;
    }
    
     //Function to load sales report
    public function salesreport(){
        PageContext::$response->section_config->report = TRUE;
        PageContext::addScript('cmshelper.js');
        
        
        //Fetch search criteria if exists
        
        $searchCriteria['startDate'] = PageContext::$request['startDate']?PageContext::$request['startDate']:PageContext::$response->startDayOfMonth;;
        $searchCriteria['endDate'] = PageContext::$request['endDate']?PageContext::$request['endDate']:PageContext::$response->endDayOfMonth;;
        
        $sectionData = Cmshelper::fetchSalesReportData($searchCriteria);
        $numRowsListData = count($sectionData);
        
        $perPageSize  =   PageContext::$response->cmsSettings['admin_page_count'];
        $totalResulPages = ceil($numRowsListData/$perPageSize);
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;
       
        $page = PageContext::$request['page'];

        if($page=="")
            $page=1;

        $startPage=($page-1)*$perPageSize;
        $limit="LIMIT $startPage,$perPageSize";
        $listDataResults = Cmshelper::fetchSalesReportData($searchCriteria, $limit);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
            $pageUrl = $pageUrl."&startDate=".PageContext::$request['startDate']."&endDate=".PageContext::$request['endDate'].'&';
        }
        else
            $pageUrl = $pageUrl."&startDate=".PageContext::$request['startDate']."&endDate=".PageContext::$request['endDate'].'&';
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($numRowsListData,$perPageSize,$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }
    
     //Function to load booking report
    public function bookingreport(){
        PageContext::$response->section_config->report = TRUE;
        PageContext::addScript('cmshelper.js');
        
        
        //Fetch search criteria if exists
        
        $searchCriteria['startDate'] = PageContext::$request['startDate']?PageContext::$request['startDate']:date('m/d/Y');
        $searchCriteria['endDate'] = PageContext::$request['endDate']?PageContext::$request['endDate']:date('m/d/Y');
        
        $sectionData = Cmshelper::fetchBookingReportData($searchCriteria);
        $numRowsListData = count($sectionData);
        
        $perPageSize  =   PageContext::$response->cmsSettings['admin_page_count'];
        $totalResulPages = ceil($numRowsListData/$perPageSize);
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;
       
        $page = PageContext::$request['page'];

        if($page=="")
            $page=1;

        $startPage=($page-1)*$perPageSize;
        $limit="LIMIT $startPage,$perPageSize";
        $listDataResults = Cmshelper::fetchBookingReportData($searchCriteria, $limit);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
            $pageUrl = $pageUrl."&startDate=".PageContext::$request['startDate']."&endDate=".PageContext::$request['endDate'].'&';
        }
        else
            $pageUrl = $pageUrl."&startDate=".PageContext::$request['startDate']."&endDate=".PageContext::$request['endDate'].'&';
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($numRowsListData,$perPageSize,$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }

    //Function to load customer report
     public function customerreport(){
        PageContext::$response->section_config->report = TRUE;
        PageContext::addScript('cmshelper.js');
        
        
        //Fetch search criteria if exists
        
        $searchCriteria['startDate'] = PageContext::$request['startDate']?PageContext::$request['startDate']:date('m/d/Y');
        $searchCriteria['endDate'] = PageContext::$request['endDate']?PageContext::$request['endDate']:date('m/d/Y');
        
        $sectionData = Cmshelper::fetchCustomerReportData($searchCriteria);
        $numRowsListData = count($sectionData);
        
        $perPageSize  =   PageContext::$response->cmsSettings['admin_page_count'];
        $totalResulPages = ceil($numRowsListData/$perPageSize);
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;
       
        $page = PageContext::$request['page'];

        if($page=="")
            $page=1;

        $startPage=($page-1)*$perPageSize;
        $limit="LIMIT $startPage,$perPageSize";
        $listDataResults = Cmshelper::fetchCustomerReportData($searchCriteria, $limit);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
           $pageUrl = $pageUrl."&startDate=".PageContext::$request['startDate']."&endDate=".PageContext::$request['endDate'].'&';
        }
        else
            $pageUrl = $pageUrl."&startDate=".PageContext::$request['startDate']."&endDate=".PageContext::$request['endDate'].'&';
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($numRowsListData,$perPageSize,$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }

    //Function to load inventory report
    public function inventoryreport(){
        PageContext::$response->section_config->report = TRUE;
        PageContext::addScript('cmshelper.js');
        $calendar = new Calendar();
        $calendar->loadJsFiles();
        $calendar->loadCssFiles();
        PageContext::addJsVar('JQ_location_id',PageContext::$request['location']);
        PageContext::addJsVar('calendarDisplayOnly', 1);
        PageContext::addPostAction('calendar','calendar','calendar');
        //Fetch search criteria if exists
        
        $searchCriteria['startDate'] = PageContext::$request['startDate']?PageContext::$request['startDate']:date('m/d/Y');
        $searchCriteria['endDate'] = PageContext::$request['endDate']?PageContext::$request['endDate']:date('m/d/Y');
        $searchCriteria['location'] = PageContext::$request['location'];
        $searchCriteria['selectedAccomodationType'] = PageContext::$request['accomodation'];
        Logger::INFO($searchCriteria);
        
        PageContext::$response->locations = Cmshelper::getLocationsHavingAccomodation();
        PageContext::$response->acoomodations = PageContext::$request['location']?Cmshelper::getAccomodationTypesByLocation(PageContext::$request['location']):Cmshelper::getAllAccomodationTypes();
        $sectionData = Cmshelper::fetchInventoryReportData($searchCriteria);
        $numRowsListData = count($sectionData);
        
        $perPageSize  =   PageContext::$response->cmsSettings['admin_page_count'];
        $totalResulPages = ceil($numRowsListData/$perPageSize);
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;
       
        $page = PageContext::$request['page'];

        if($page=="")
            $page=1;

        $startPage = ($page-1)*$perPageSize;
        $limit = "LIMIT $startPage,$perPageSize";
        $listDataResults = Cmshelper::fetchInventoryReportData($searchCriteria, $startPage, $perPageSize);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        
        if(PageContext::$request['page']!="") {
            $pageUrl = $pageUrl;
            $pageUrl = str_replace("page=".PageContext::$request['page'], "", $pageUrl);
            $pageUrl = $pageUrl."&startDate=".PageContext::$request['startDate']."&endDate=".PageContext::$request['endDate'].'&location='.PageContext::$request['location'].'&accomodation='.PageContext::$request['accomodation'].'&';
        }
        else
             $pageUrl = $pageUrl."&startDate=".PageContext::$request['startDate']."&endDate=".PageContext::$request['endDate'].'&location='.PageContext::$request['location'].'&accomodation='.PageContext::$request['accomodation'].'&';
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($numRowsListData,$perPageSize,$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
        PageContext::addPostAction("inventoryreportlistview", "cmshelper", "default");
    }
    
    //Function to load inventory report list view
    public function inventoryreportlistview($ajaxCall){
        
        if($ajaxCall == 'ajax'){
            PageContext::addPostAction("inventoryreportlistview", "cmshelper", "default");
            PageContext::renderPostAction("inventoryreportlistview", "cmshelper", "default");
        }
    }

    //Function to generate excel report
    public function getExcelReport(){
        
        $section                =   $_GET['requestHeader'];
       
        $searchCriteria['startDate']       =    str_replace("-","/",$_GET['reportStartDate']);
        $searchCriteria['endDate']      =     str_replace("-","/",$_GET['reportEndDate']);
        $reportColumnCount      =    count($sectionData);
        switch(PageContext::$request['category'] ){
            case 'sales':
                $reportHeading = "Report: Sales Report From ".$searchCriteria['startDate']." To ".$searchCriteria['endDate'];
                $dataArray ['data'] =  Cmshelper::fetchSalesReportData($searchCriteria,'',TRUE);
                $dataArray['columns'] = array('Customer', 'Booked On', 'Order Total ($)', 'Transaction Id', 'Settled date', 'Payment Type', 'Settled' );
                $reportFileName = "Sales-Report".$searchCriteria['startDate']."-".$searchCriteria['endDate'];
            break;
        
            case 'booking':
                $reportHeading = "Report: Booking Report From ".$searchCriteria['startDate']." To ".$searchCriteria['endDate'];
                $dataArray ['data'] =  Cmshelper::fetchBookingReportData($searchCriteria,'',TRUE);
                $dataArray['columns'] = array('ID','Customer', 'Booked On','Check In ','Check Out ', 'Order Total ($)', 'Details', ' Status');
                $reportFileName = "Booking-Report".$searchCriteria['startDate']."-".$searchCriteria['endDate'];
            break;
        
            case 'customer':
                $reportHeading = "Report: Customer Report From ".$searchCriteria['startDate']." To ".$searchCriteria['endDate'];
                $dataArray ['data'] =  Cmshelper::fetchCustomerReportData($searchCriteria,'',TRUE);
                $dataArray['columns'] = array('Login', 'First name','Last name ','Email ', 'Address', 'City', ' State', ' Country', ' Zip', ' Mobile', ' Telephone', ' Fax', 'Status', 'Joined On');
                $reportFileName = "Customer-Report".$searchCriteria['startDate']."-".$searchCriteria['endDate'];
            break;
            
            case 'inventory':
                $searchCriteria['location'] = PageContext::$request['location'];
                $searchCriteria['selectedAccomodationType'] = PageContext::$request['accomodation'];
                $reportHeading = "Report: Inventory Report From ".$searchCriteria['startDate']." To ".$searchCriteria['endDate'];
                $dataArray ['data'] =  Cmshelper::fetchInventoryReportData($searchCriteria);
                $dataArray['columns'] = array('Date', 'Status','Total Rooms ','Booked Rooms', 'Booked By');
                $reportFileName = "Inventory-Report".$searchCriteria['startDate']."-".$searchCriteria['endDate'];
            break;
        }
        
        Apputils::generateListingExcelReport($dataArray, $reportHeading, $reportFileName);
        exit;
      
    }
    
    //Function to perform offline booking
    public function booking(){ 
        PageContext::$response->destinations            = Cmshelper::getDestinationsHavingAccomodation();
        PageContext::$response->locations               = Cmshelper::getLocationsHavingAccomodation();
        PageContext::$response->accomodationTypes       = Cmshelper::getAllAccomodationTypes();

        PageContext::addScript('cmshelper.js');
        PageContext::addScript('country-state.js');
        
        $error = FALSE;
        PageContext::$response->success = FALSE;
        
        if(PageContext::$request['bookRoom'] == 'Book')
        {
            
            $requestArray['bookingOption'] = PageContext::$request['jqBookingOption'];
            
        if($requestArray['bookingOption'] == 'existingCustomerBooking'){
            $userStatus = Customer::checkEmailExits(PageContext::$request['jqCustomerEmail']);
            if($userStatus == false){
                $error = TRUE;
                PageContext::$response->message = 'Customer does not exist.Please proceed with user details for booking';
            }
                
        }else if($requestArray['bookingOption'] == 'newCustomerBooking' && Customer::checkEmailExits(PageContext::$request['email'])){
            $error = TRUE;
            PageContext::$response->message = 'Customer  exist with email.Please proceed with booking with existing account';
        }
        
        if(!$error){
            $requestArray['destination'] = PageContext::$request['jqHdestination'];
            $requestArray['location'] = PageContext::$request['jqHLocation'];
            $requestArray['accomodation'] = PageContext::$request['jqHAccomodation'];
            $requestArray['startDate'] = PageContext::$request['jqHStartDate'];
            $requestArray['endDate'] = PageContext::$request['jqHEndDate'];
            $requestArray['roomCount'] = PageContext::$request['jqHRoomCount'];
            $requestArray['adults'] =  PageContext::$request['jqHAdultCount'];


            $availability = Cmshelper::checkRoomAvailability($requestArray);           

           
             
            if($availability['availability']){
                if($requestArray['bookingOption'] == 'newCustomerBooking'){
                    $userrequestArray['txtFirstName'] = PageContext::$request['firstName'];
                    $userrequestArray['txtLastName'] = PageContext::$request['lastName'];

                    $customerFirstName = PageContext::$request['firstName'];
                    $customerLastName = PageContext::$request['lastName'];


                    $userrequestArray['txtAddress1'] = PageContext::$request['addressLine1'];
                    $userrequestArray['txtAddress2'] = PageContext::$request['addressLine2'];
                    $userrequestArray['txtCity'] = PageContext::$request['city'];
                    $userrequestArray['txtState'] = PageContext::$request['txtState'];
                    $userrequestArray['txtCountry'] = PageContext::$request['txtCountry'];
                    $userrequestArray['txtZip'] = PageContext::$request['zip'];
                    $userrequestArray['mobile'] = PageContext::$request['mobile'];
                    $userrequestArray['telephone'] = PageContext::$request['telephone'];
                    $userrequestArray['txtFax'] = PageContext::$request['fax'];
                    $userrequestArray['txtEmail'] = PageContext::$request['email'];
                    $customerName = $userrequestArray['txtFirstName']. ' '. $userrequestArray['txtLastName'];
                    $customerEmail = $userrequestArray['txtEmail'] ;
                    Logger::INFO($userrequestArray);
                    $customerId = Customer::addCustomer($userrequestArray,FALSE);
                }else{
                     $customer = Customer::getCustomerDetailsByEmail(PageContext::$request['jqCustomerEmail']);
                     Logger::info($customer);
                     $customerId = $customer[0]->nCust_Id;
                     $customerName = $customer[0]->vFirstname. ' '. $customer[0]->vLastname;
                     $customerEmail = $customer[0]->vEmail ;

                     $customerFirstName = $customer[0]->vFirstname;
                     $customerLastName   = $customer[0]->vLastname;
                }
                
                if($requestArray['bookingOption'] == 'adminBooking')
                {
                    //$customerId = Customer::addCustomer($userrequestArray,FALSE);

                    
                     $adminEmail                     = Apputils::fetchSettings('vadmin_email');

                     $dataArray['vFirstname']        = 'Admin - Booking';
                     $dataArray['vLastname']         = '';
                     $dataArray['vEmail']            = $adminEmail;

                     $dataArray['dDatejoin']         = date('Y-m-d');
                     $dataArray['vActive']           = 'active';


                     //$customerId = $db->insert(MYSQL_TABLE_PREFIX.$table, $dataArray);


                    
                    $userLevel = 'ADMIN';
                    $customerId = 0;
                }
                else
                    $userLevel = 'USERS';
                
                Logger::info($customerId);
                $bookingId = Booking::recordOrder($customerId,PageContext::$request['jqHAccomodation'],$availability['accomodationAvailabilityId'],  PageContext::$request['jqHAdultCount'],PageContext::$request['jqHChildrenCount'], Utils::dateFormat($requestArray['startDate'],'m/d/Y','Y-m-d H:i:s'),  Utils::dateFormat($requestArray['endDate'],'m/d/Y','Y-m-d H:i:s'),
                        $availability['booking_amount'],DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT,$availability['startingPrice'],DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT,$requestArray['roomCount'],$userLevel);
                if($bookingId)
                {
                    $bookingDetails = array();


                    $bookingDetails['arrivalDate']               = $requestArray['startDate'];
                    $bookingDetails['departureDate']             = $requestArray['endDate'];
                    $bookingDetails['nAdults']                   = PageContext::$request['jqHAdultCount'];
                    $bookingDetails['numberOfChildren']          = PageContext::$request['jqHChildrenCount'];
                    $bookingDetails['amountToPayForBooking']     = $availability['startingPrice'];
                   
                  
                    $bookingDetails['siteBookingMode']           = DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT;
                    $bookingDetails['accomadationType']          = PageContext::$request['jqHAccomodation'];
                    
                    
                    
                    $bookingDetails['locationName']              = Booking::getLocationName($bookingId);
                    $bookingDetails['extraPrice']                = $availability['booking_amount'];
                    $bookingDetails['destinationName']           = Booking::getDestinationName($bookingId);
                    $bookingDetails['numberOfRooms']             = $requestArray['roomCount'];



                     

                    $bookingDetails['firstName']                 = $customerFirstName;
                    $bookingDetails['lastName']                  = $customerLastName;

                    
                     if($requestArray['bookingOption'] != 'adminBooking'){
                          $bookingDetails['name']               = $customerName;
                        Booking::sendOfflineInvoice($customerEmail,$bookingDetails,'User');
                        Booking::sendOfflineInvoice($customerEmail,$bookingDetails,'Admin');
                     }else{
                        $bookingDetails['name']      = 'Admin';
                        $emailAddress = Apputils::fetchSettings('vadmin_email');




                        Booking::sendOfflineInvoice($emailAddress,$bookingDetails,'Admin');
                     }
                }
                
                Logger::info($bookingId);
                PageContext::$response->message ='Room reserved successfully';
                PageContext::$response->success = TRUE;
            
            }
            else if($availability['status'] == 'blocked')
            {
                $error = TRUE;
                PageContext::$response->message = $availability['message'];
            }


            else{
                $error = TRUE;
                PageContext::$response->message = 'Selected Room Type Not available';
            }
            
        }
        }
    }
    
    //Function to check customer exists [ajax- Offline booking]
    public function checkCustomerEmailStatus(){
        $userStatus = Customer::checkEmailExits(PageContext::$request['email']);
        echo $userStatus;
        exit;
    }
    
    //Function to check room availability [ajax - Offline Booking]
    public function checkroomavailability(){
        $requestArray['location'] = PageContext::$request['location'];
        $requestArray['accomodation'] = PageContext::$request['accomodation'];
        $requestArray['roomCount'] = PageContext::$request['roomCount'];
        $requestArray['startDate'] = PageContext::$request['startDate'];
        $requestArray['endDate'] = PageContext::$request['endDate'];
        $requestArray['startDate'] = str_replace("-", "/", $requestArray['startDate']);
        $requestArray['endDate'] = str_replace("-", "/", $requestArray['endDate']);
        $requestArray['adults'] =  PageContext::$request['adults'];
        $availability = Cmshelper::checkRoomAvailability($requestArray);


        if($availability['availability'])
        {
            if($availability['guest'] == '') $availability['guest']= 0;
           echo  json_encode(array('status'=>TRUE,'message'=>'Selected Room Type  available. 
               <br> Single Room can accommodate '.$availability['adults'].' adults and '.$availability['children'].' children
                   <br>Guest Allowed :'. $availability['guest'].
                   '<br>Amount Payable : '.SITE_CURRENCY.' '.$availability['booking_amount']));
        }
        else if($availability['status'] == 'blocked')
        {
                echo json_encode(array('status'=>FALSE,'message'=>$availability['message']));
        }
        else
        {
             echo json_encode(array('status'=>FALSE,'message'=>'Selected Room Type Not available'));
        }
        
        exit();
    }
    
    //Function to change user status
    public function ajaxUserStatusChange(){
       print_r(PageContext::$request);
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateUserStatus($id,$value);
        }
        exit();
    }
       public function ajaxPenalityStatusChange(){
       print_r(PageContext::$request);
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updatePenalityStatus($id,$value);
        }
        exit();
    }
    //Function to change banner status
    public function ajaxBannerStatusChange(){
       print_r(PageContext::$request);
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateBannerStatus($id,$value);
        }
        exit();
    }
    
    //Function to change location status
    public function ajaxLocationStatusChange(){
       
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateLocationStatus($id,$value);
        }
        exit();
    }
    
    
 	//Function to change affiliate urls status
    public function ajaxAffiliateLinkStatusChange(){
       
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateAffiliateLinkStatus($id,$value);
        }
        exit();
    }
    
    //Function to destination status
    public function ajaxDestinationStatusChange(){
       
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateDestinationStatus($id,$value);
        }
        exit();
    }
    
    //Function to change location featured  status
    public function ajaxLocationFeaturedStatusChange(){
       
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateLocationFeaturedStatus($id,$value);
        }
        exit();
    }
    
    //Function to change accomodation status
    public function ajaxAccomodationStatusChange(){
       
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateAccomodationStatus($id,$value);
        }
        exit();
    }

    //Function to change accomodation avilabiluty status
    public function ajaxAccomodationAvailabilityStatusChange(){

        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateAccomodationAvailabilityStatus($id,$value);
        }
        exit();
    }



    
    //Function to change mail template status
    public function ajaxMailTemplateStatusChange(){
       
        $id    = PageContext::$request['id'];
        $value = PageContext::$request['value'];
        if($id>0){
            $updateVal = Cmshelper::updateMailTemplateStatus($id,$value);
        }
        exit();
    }
    
    //Function to load invoice details pop up
    public function invoicedetailspopup(){
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $orderId    = PageContext::$request['id'];
        PageContext::$response->bookingDetails = Cmshelper::getBookingDetails($orderId);
        
        PageContext::$response->companyAddress = PageContext::$response->settings['admin_address'];
        PageContext::$response->companyName = PageContext::$response->settings['companyName'];
        PageContext::$response->companyPhone = PageContext::$response->settings['companyPhone'];
        PageContext::$response->companySite = PageContext::$response->settings['companySite'];
        PageContext::$response->companyMail = PageContext::$response->settings['vadmin_email'];
        
    }

    //Function to load user details pop up
     public function userdetailspopup(){
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $customerId    = PageContext::$request['id'];
        if($customerId == 0){
            PageContext::$response->hideUserSpecificColumns = 1;
            PageContext::$response->settings = Apputils::loadSettings();
        }else{
            PageContext::$response->hideUserSpecificColumns = 0;
        }
        PageContext::$response->customerDetails = Customer::getCustomerDetails($customerId);
        
    }
    
    //Function to load location details pop up
    public function locationdetailspopup(){
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $locationId    = PageContext::$request['id'];
        PageContext::$response->locationDetails = Cmshelper::fetchLocationdestinationDetails($locationId);
        
    }
    
    //Function to load destination details pop up
    public function destinationdetailspopup(){
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $destinationId    = PageContext::$request['id'];
        PageContext::$response->destinationDetails = Cmshelper::fetchDestinationDetails($destinationId);
        
    }
    
    //Function to load acoomodation details pop up
    public function accomodationdetailspopup(){
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $accomoId    = PageContext::$request['id'];
        PageContext::$response->accomodationDetails = Cmshelper::fetchAccomodationDetails($accomoId);
        
    }
    
    //Function to load order status change pop up
    public function orderstatuschangepopup(){
          PageContext::addScript("cmshelper.js");
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $orderId    = PageContext::$request['id'];
        PageContext::$response->orderDetails = Cmshelper::getOrderDetails($orderId);
        
    }
    
    //Function to update order status
    public function updateOrderStatus(){
      
        Cmshelper::updateOrderStatus(PageContext::$request['nBooking_Id'], PageContext::$request['orderStatus']);

        if(PageContext::$request['orderStatus']=='canceled'){
            // Mail send to user/admin while a user cancel a booking
            Cancel::sendCancelMail(PageContext::$request['nBooking_Id'],'User');
            Cancel::sendCancelMail(PageContext::$request['nBooking_Id'],'Admin');
        }
        
        echo 'Status Changed Successfully';
        exit;
       
    }
    
    //Function to load feedback user details pop up
     public function feedbackuserdetailspopup(){
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $feedbackId    = PageContext::$request['id'];
        PageContext::$response->feedBackDetails = Cmshelper::getFeedbackDetails($feedbackId);
    }
    
     //Function to load inquiry user details pop up
    public function inquiryuserdetailspopup(){
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $enqId    = PageContext::$request['id'];
        PageContext::$response->inquiryDetails = Cmshelper::getInquiryDetails($enqId);
        //echopre(PageContext::$response->inquiryDetails);
    }
    
    //Function to load quick start guide pop up
    public function quickstartguidepopup(){
    	PageContext::$response->siteName = Utils::getSettingsData('sitename');
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
    }
    
    //Function to load inquiry reply pop up
    public function replyinquirypopup(){
        PageContext::addScript("cmshelper.js");
        PageContext::$response->enqId = PageContext::$request['id'];
        
        PageContext::$response->editorObject = Apputils::createEditorInstance('emailContent') ;
       
        PageContext::$response->enqDetails = $enqDetails = Cmshelper::getInquiryDetails(PageContext::$response->enqId); 
        PageContext::$response->email = $enqDetails->vEmail;
        PageContext::$response->amount = PageContext::$request['amount'];
        PageContext::$response->customer = PageContext::$request['customer'];
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $orderId    = PageContext::$request['id'];
        PageContext::$response->orderDetails = Cmshelper::getOrderDetails($orderId);
        
    }
    
    //Funntion to update replay status [ajax]
    public function updateReplyStatus(){


        $emailContent = str_replace('-delemiter-', '&', PageContext::$request['emailContent']);
        //$emailContent = htmlspecialchars($emailContent);

        $enqDetails   = Cmshelper::getInquiryDetails(PageContext::$request['enqId']);       

        Apputils::sendCustomisedUserMail($enqDetails->vName, $enqDetails->vEmail, PageContext::$request['subject'], $emailContent);
        Cmshelper::updateInquiry(PageContext::$request['enqId']);
        echo  "Reply sent Successfully";
        exit;
       
    }
    
    //Function to check existence of penalty [ajax]
    public function checkExistenceOfPenalty(){
      
        $numberOfDays = PageContext::$request['numberOfDays'];
        $penaltyId = PageContext::$request['penaltyId'];
        $penaltyDetails = Cmshelper::checkPenaltyDetails($numberOfDays, $penaltyId);
       
        if(count($penaltyDetails)>0)
            echo FALSE;
        else 
           echo TRUE;

        exit;
       
    }
    
    //Function to load manage penalty in settings
    public function managepenalty(){
               
        PageContext::addScript('settingsdisplay.js');
        
        $sectionData = Cmshelper::fetchPenalties();
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
       
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =  $pageDetails[0];
        $listDataResults = Cmshelper::fetchPenalties($pageDetails[1]);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .="&";
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2],PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }
    
    //Function to load navigation in settings
    public function managenavigation(){
        PageContext::addScript('settingsdisplay.js');
        
        $sectionData = Cmshelper::fetchNavigations();
        
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
       
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =  $pageDetails[0];
        $listDataResults = Cmshelper::fetchNavigation($pageDetails[1]);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .="&";
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2],PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }
    
    
    //Function to load admin help content
    public static function adminhelpcontent(){
       PageContext::addStyle("cmssettings.css");     
         if(isset(PageContext::$request['addAccomodation'])){
             
            Logger::info(PageContext::$request);
            $requestArray ['hcid'] = PageContext::$request['category'];
            $requestArray ['htitle'] = PageContext::$request['title'];
            $requestArray ['hdescription'] = PageContext::$request['description'];
            $requestArray ['hposition'] = PageContext::$request['position'];
            $requestArray ['active'] = PageContext::$request['status'];
           
            if($_FILES['file_id']['tmp_name']!=""){
                $fileHandler = new Filehandler();
                $fileDetails = $fileHandler->handleUpload($_FILES['file_id']);
                $requestArray['file_id'] = $fileDetails->file_id;
            }
            
            if(PageContext::$request['helpId'] == NULL){
                Cmshelper::addHelpContent($requestArray);
                PageContext::$response->message = "Help Content Added Successfully";
            }else{
                Cmshelper::updateHelpContent($requestArray, PageContext::$request['helpId']);
                PageContext::$response->message = "Help Content Updated Successfully";
            }
            
        }
        
        PageContext::addScript('cmshelper.js');
      
        PageContext::$response->categories =  Cmshelper::getHelpCategoriesByType('admin');
        if(PageContext::$request['section_action'] == 'edit_help_content'||PageContext::$request['section_action'] == 'add_help_content'){
            PageContext::$response->editorObject = Apputils::createEditorInstance('description');;
            PageContext::$response->showAddForm = TRUE;
            PageContext::$response->helpId =  PageContext::$request['help'];
        }else if(PageContext::$request['section_action'] == 'delete'){
            Cmshelper::removeHelpContent(PageContext::$request['help']);
            PageContext::$response->message = "Help Content Removed Successfully";
        }
        
        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];
      
        $sectionData = Cmshelper::fetchHelpContents('admin',$searchCriteria);
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
       
        PageContext::addJsVar("totalResulPages", $pageDetails[0]);
        PageContext::$response->resultPageCount =   $pageDetails[0];
       
        $listDataResults = Cmshelper::fetchHelpContents('admin', $searchCriteria, $pageDetails[1]);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .= "&";
        
        if($searchCriteria['searchText'] != '')
            $pageUrl .= "searchTextCustom=".$searchCriteria['searchText']."&searchFieldCustom=".$searchCriteria['searchField'].'&';
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2],PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }
    
    //Function to load client help content
    public static function clienthelpcontent(){
       PageContext::addStyle("cmssettings.css");     
         if(isset(PageContext::$request['addAccomodation'])){
          
            $requestArray ['hcid'] = PageContext::$request['category'];
            $requestArray ['htitle'] = PageContext::$request['title'];
            $requestArray ['hdescription'] = PageContext::$request['description'];
            $requestArray ['hposition'] = PageContext::$request['position'];
            $requestArray ['active'] = PageContext::$request['status'];
          
            if($_FILES['file_id']['tmp_name']!=""){
                $fileHandler = new Filehandler();
                $fileDetails = $fileHandler->handleUpload($_FILES['file_id']);
                $requestArray['file_id'] = $fileDetails->file_id;
            }
            
            if(PageContext::$request['helpId'] == NULL){
                Cmshelper::addHelpContent($requestArray);
                PageContext::$response->message = "Help Content Added Successfully";
            }else{
                Cmshelper::updateHelpContent($requestArray, PageContext::$request['helpId']);
                PageContext::$response->message = "Help Content Updated Successfully";
            }
       
        }
        
        PageContext::addScript('cmshelper.js');
      
        PageContext::$response->categories =  Cmshelper::getHelpCategoriesByType('client');
        if(PageContext::$request['section_action'] == 'edit_help_content'||PageContext::$request['section_action'] == 'add_help_content'){
            PageContext::$response->editorObject = Apputils::createEditorInstance('description');
            PageContext::$response->showAddForm = TRUE;
            PageContext::$response->helpId =  PageContext::$request['help'];
           
        }else if(PageContext::$request['section_action'] == 'delete'){
            Cmshelper::removeHelpContent(PageContext::$request['help']);
            PageContext::$response->message = "Help Content Removed Successfully";
        }
        
        //Fetch search criteria if exists
        $searchCriteria['searchField'] = PageContext::$request['searchFieldCustom'];
        $searchCriteria['searchText'] = PageContext::$request['searchTextCustom'];
       
        $sectionData = Cmshelper::fetchHelpContents('client',$searchCriteria);
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
        PageContext::addJsVar("totalResulPages", $pageDetails[0]);
        PageContext::$response->resultPageCount =   $pageDetails[0];
        $listDataResults = Cmshelper::fetchHelpContents('client', $searchCriteria, $pageDetails[1]);
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .= "&";
       
        if($searchCriteria['searchText'] != '')
            $pageUrl .= "&searchTextCustom=".$searchCriteria['searchText']."&searchFieldCustom=".$searchCriteria['searchField'].'&';
        
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
        PageContext::$response->pagination      =   Cms::pagination($pageDetails[2],PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        PageContext::$response->pageContents    = $listDataResults;
    }
    
        //Function to load client help content
    public static function adminhelplistings(){
       PageContext::addStyle("cmssettings.css");     
       PageContext::addScript('cmshelper.js');
      
        $result = Cmshelper::fetchAdminHelpListings();
        $sectionData = $result['data'];
        $pageDetails = Apputils::calculateResultPageCount($sectionData, PageContext::$response->cmsSettings['admin_page_count'], PageContext::$request['page']);
      
        $adminPageCount = PageContext::$response->cmsSettings['admin_page_count'];
        $numRowsListData = $result['count'];
        $totalResulPages = ceil($numRowsListData/$adminPageCount);
       
        $page = PageContext::$request['page'];
        if($page=="")
            $page = 1;

        $startPage = ($page-1)*$adminPageCount;
        $limit = "LIMIT $startPage,$adminPageCount";
        
        PageContext::addJsVar("totalResulPages", $totalResulPages);
        PageContext::$response->resultPageCount =   $totalResulPages;
       
        $pageUrl = Cms::formPagingUrl(PageContext::$request);
        $pageUrl .= "&";
       
        PageContext::addJsVar("currentURL", $pageUrl);
        PageContext::$response->currentURL = $pageUrl;
      
        PageContext::$response->pagination      = Cms::pagination($numRowsListData,PageContext::$response->cmsSettings['admin_page_count'],$pageUrl,PageContext::$request['page']);
        $result = Cmshelper::fetchAdminHelpListings($limit);
        PageContext::$response->pageContents    = $result['data'];
    }

    public function ajaxGetLocationState($locationId){
        $stateVal = Location::getLocationDetails($locationId);
        if($stateVal->vState!=''){
            echo $stateVal->vState;
        }else{
            echo '';
        }
        exit;
    }

    public function ajaxGetStatesByCountry($countryCode,$locationId=0,$mode=''){

        if($mode=='edit' && $locationId > 0 ){
            $stateVal = Location::getLocationDetails($locationId);
        }
        $states = Utils::getStatesByCountry($countryCode);
        $stateContent = '';
        foreach($states AS $state){
            if($stateVal->vState!='')
                $selected = ($stateVal->vState==$state->ts_code)?'selected':'';
            $stateContent .= "<option value ='".$state->ts_code."' ".$selected." >".$state->ts_name."</option>";
        }
        print_r($stateContent);
        exit;
    }


    //Function to load affiliate settle pop up
    public function affiliatesettlepopup(){ 
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $affiliateId  = PageContext::$request['id'];
        PageContext::$response->affiliateAmount = Cmshelper::getTotalAffilateAmount($affiliateId);
    }

    //Function to setle affiliate payment
    public function ajaxSettleAffiliatePayment(){
        
        $affliateId  = PageContext::$request['affiliateId'];
        $paymentType = PageContext::$request['paymentType'];
        $settlePayment = Cmshelper::settleAffiliatePayment($affliateId,$paymentType);
        if($settlePayment) echo 'success';
        exit;
    }
}
?>
