<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                               |
// +----------------------------------------------------------------------+
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------

class ControllerBooknow extends BaseController {

    public function init() {

        parent::init();
        
        $this->_common	                     = new ModelCommon();
        $this->_session                      = new LibSession();
        PageContext::$body_class             = 'Payment';

        PageContext::addJsVar("BASE_URL", BASE_URL);
        PageContext::addStyle('order.css',true);
        PageContext::addScript('booknow.js');
        PageContext::addScript('tooltip.js');
        PageContext::addScript('jquery-ui-timepicker-addon.js');
        PageContext::addScript('jquery.watermark.js');
        PageContext::addStyle('signup.css',true);
        PageContext::addStyle("jquery-ui-1.8.23.custom.css",true);
        //PageContext::addScript('country-state.js');

    }



    public function index() { 
        // Meta Data
        Utils::getMetaContents('booknow');
        //	echopre($_SESSION);
        global $imageConfig;

        $customerDetails                           = json_decode($this->_session->get('customer')); 
        $cart 		                            = new Cart('customer_cart',$customerDetails->nCust_Id);
        $tempLastBookingDetails                    = json_decode($this->_session->get('last_booking_details'));



        if($customerDetails->nCust_Id>0)
            PageContext::addJsVar('JQ_is_logged_in', '1');
        else
            PageContext::addJsVar('JQ_is_logged_in', '0');


        PageContext::$response->tempLastBookingDetails = $tempLastBookingDetails;
        PageContext::addJsVar('JQ_starting_price', $tempLastBookingDetails->startingPrice);



        $amountToPay                 = Apputils::fetchSettings('ReserveModeAmount');
        $bookingPaymentMode          = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
        $reservationModeAmount       = $amountToPay;




        if($reservationModeAmount>0 && $bookingPaymentMode == 'Per') {
            PageContext::$response->adminSetPercentage = $reservationModeAmount;
        }
        else {
            PageContext::$response->adminSetPercentage = '';
        }

        PageContext::$response->selectedFromDate    = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','m/d/Y');
        PageContext::$response->selectedToDate      = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','m/d/Y');
        PageContext::$response->numberOfPeople      = $tempLastBookingDetails->numberOfPeople;
        PageContext::$response->numberOfChildren    = ($tempLastBookingDetails->numberOfChildren>0) ? $tempLastBookingDetails->numberOfChildren : 0;
        PageContext::$response->tempLastBookingDetails->amountToPayForBooking = $tempLastBookingDetails->amountToPayForBooking;

        
        PageContext::addJsVar('JQ_payment_customer_first_name', $customerDetails->vFirstname);
        PageContext::addJsVar('JQ_payment_customer_last_name', $customerDetails->vLastname);
        PageContext::addJsVar('JQ_payment_customer_email', $customerDetails->vEmail);
        PageContext::addJsVar('JQ_payment_customer_address', urlencode($customerDetails->vAddress1));
        PageContext::addJsVar('JQ_payment_customer_city', $customerDetails->vCity);
        PageContext::addJsVar('JQ_payment_customer_state', $customerDetails->vState);
        PageContext::addJsVar('JQ_payment_customer_country', $customerDetails->vCountry);
        PageContext::addJsVar('JQ_payment_customer_zip', $customerDetails->vZip);
        PageContext::addJsVar('JQ_payment_amount', $tempLastBookingDetails->amountToPayForBooking);



        if($tempLastBookingDetails->numberOfRooms>0) {
            PageContext::$response->numberOfRooms = $tempLastBookingDetails->numberOfRooms;
            $numberOfRooms                        = $tempLastBookingDetails->numberOfRooms;
        }
        else {
            PageContext::$response->numberOfRooms = 1;
            $numberOfRooms                        = 1;
        }

        if(!isset($tempLastBookingDetails)) {
            $this->redirect('search');
        }

        PageContext::addJsVar('JQ_site_booking_mode',$tempLastBookingDetails->siteBookingMode);

        $locationId = $tempLastBookingDetails->locationId;
        PageContext::$response->accomadationName = Location::getAccomadationName($tempLastBookingDetails->accomadationType);
        PageContext::addJsVar("JQ_location_id", $locationId);


        /// ****************get location details ******************************//




        $details                                           = Location::getLocationDetails($locationId);
        $roomDetails                                       = Location::getLocationRoomInfo($locationId);
        $galleyDetails                                     = Location::getLocationImages($locationId);


        PageContext::$response->locationId                 = $locationId;
        PageContext::$response->locationDetails            = $details;

        $tempLocationDescription                           = htmlentities(stripslashes(trim($details->vLocation_Description)));
        $tempLocationName                                  = htmlentities(stripslashes(trim($details->vLocation_Name)));
        $tempLocationAddress                               = htmlentities(stripslashes(trim($details->vAddress)));
        $tempLocationAmenities                             = stripslashes(trim($details->vAmenities));


        PageContext::$response->destinationId              = $details->nDestination_Id;
        PageContext::$response->locationDescription        = ($tempLocationDescription=='') ? 'No description available !!!' : $tempLocationDescription;
        PageContext::$response->locationName               = ($tempLocationName=='') ? 'Unknown location' : $tempLocationName;
        PageContext::$response->locationAddress            = ($tempLocationAddress=='') ? 'Unknown address' : $tempLocationAddress;
        PageContext::$response->locationStartingPrice      = ($details->nStartingPrice>0) ? $details->nStartingPrice : '0.00';
        PageContext::$response->locationAmenities          = $tempLocationAmenities;
        PageContext::$response->locationGallery            = $galleyDetails;

        $tempAddressString  = $details->vAddress.',&nbsp;'.$details->vCity.',&nbsp;'.$details->vState.',&nbsp;'.$details->vZip.',&nbsp;'.$details->vCountry;

        PageContext::$response->singleLineAddress          = $tempAddressString;




        foreach(PageContext::$response->locationGallery as $tempKey => $tempValue) {

            PageContext::$response->defaultGalleryThumbImage        = BASE_URL . 'project/files/' .  $imageConfig['locationThumb']['prefix']. $tempValue->file_path;
            PageContext::$response->defaultGalleryImagetTitle       = $tempValue->vTitle	 ;
            break;
        }

        //******************end of location details *****************************//
        /*
        	 
        */

        if($tempLastBookingDetails->apiType == 'Expedia') {

            PageContext::addJsVar("JQ_locationtype", 'expedia');

            //echopre($tempLastBookingDetails);

            $searchParams['hotelId'] = $tempLastBookingDetails->locationId;
            $hotelInfo = Apisearch::expediaHotelInfo($searchParams);
           

            // find location name
            foreach($hotelInfo->roomTypes as $rooms) {
                if($rooms->nAt_Id == $tempLastBookingDetails->accomadationType) {
                    PageContext::$response->accomadationName = $rooms->vAt_Name;
                    break;
                }
            }


            // find location image
            // echo sizeof($hotelInfo->locationGallery);

            if(sizeof($hotelInfo->locationGallery) > 0) {
                PageContext::$response->defaultGalleryThumbImage = $hotelInfo->locationGallery[0]['thumbnail'];
            }




            PageContext::$response->locationDetails->vLocation_Name       = $hotelInfo->locationName;
            PageContext::$response->locationDetails->vCity       		= $hotelInfo->city;
            PageContext::$response->singleLineAddress       = $hotelInfo->locationAddress.' ,'.$hotelInfo->city.' ,'.$hotelInfo->countryCode;




        }
        else {
            PageContext::addJsVar("JQ_locationtype", 'db');
        }




        PageContext::registerPostAction("center-main", "index","booknow","default");

    }

    /* post action */
    public function contactInformation() {


        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        $customerDetails   = json_decode($this->_session->get('customer'));
        
        
        

        if(($customerDetails->nCust_Id == '' || $customerDetails->nCust_Id == 0) &&  PageContext::$request['byPass'] != 1) {

            $txtEmail    = PageContext::$request['txtEmail'];
            $txtPassword = PageContext::$request['txtPassword'];

            $txtEmail    = trim($txtEmail);
            $txtPassword = trim($txtPassword);


            if($txtEmail !='' && $txtPassword != '') {
                $postArray = array();

                $postArray['txtUserName']       = $txtEmail;
                $postArray['txtPassword']       = md5($txtPassword);
                $postArray['login_remember_me'] = false;

                $tempStatus                     = Customer::doLogin($postArray);

                if($tempStatus == 1) {
                    $customerDetails   = json_decode($this->_session->get('customer'));
                }
                else if($tempStatus == 404 || $tempStatus == 403) {
                    print $tempStatus;
                    exit();
                }
                else {
                    print 404;
                    exit();
                }

            }
            else {
                print 404;
                exit();
            }


        }
        else if(PageContext::$request['autoRegister'] == 1) {
            $txtEmail    = PageContext::$request['txtEmail'];

            if(Customer::checkEmailExits($txtEmail)) {
                print 202;
                exit();
            }
            else {
                //txtEmail
                Customer::addCustomer(array('txtEmail'=>$txtEmail));
                $customerDetails   = json_decode($this->_session->get('customer'));

            }
        }

        $tempDetails       = Customer::getCustomerDetails($customerDetails->nCust_Id);
        PageContext::$response->countries = Utils::getCountries();
        $countryVal = ($tempDetails[0]->vCountry)?$tempDetails[0]->vCountry:'US';
        PageContext::$response->states   = Utils::getStatesByCountry($countryVal); 


        $tempLastBookingDetails                        = json_decode($this->_session->get('last_booking_details'));
        PageContext::$response->tempLastBookingDetails = $tempLastBookingDetails;

        PageContext::addJsVar('JQ_starting_price', $tempLastBookingDetails->startingPrice);
        PageContext::addJsVar('JQ_site_booking_mode',$tempLastBookingDetails->siteBookingMode);

        

        PageContext::$response->customerDetails=$tempDetails;
        PageContext::$response->customerDetails[0]->vCountry = (PageContext::$response->customerDetails[0]->vCountry=='') ? 'US' : PageContext::$response->customerDetails[0]->vCountry;
        PageContext::$response->customerDetails[0]->vState   = (PageContext::$response->customerDetails[0]->vState=='') ? 'AK' : PageContext::$response->customerDetails[0]->vState;

    }




    /* Ajax function for rendering login during booking flow */
    public function contactQuestions() { 
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        $tempLastBookingDetails                        = json_decode($this->_session->get('last_booking_details'));
        PageContext::$response->tempLastBookingDetails = $tempLastBookingDetails;
    }


    public function complete() {



        $bookingCompleteDetails = array();
        PageContext::registerPostAction("center-main", "complete","booknow","default");

        $objSearchParams                               = $this->_session->get('SearchObject');
        PageContext::$response->objSearchParams        = $objSearchParams;

        $customerDetails                               = json_decode($this->_session->get('customer'));
        $tempLastBookingDetails                        = json_decode($this->_session->get('last_booking_details'));


        PageContext::$response->tempLastBookingDetails = $tempLastBookingDetails;

       //if($tempLastBookingDetails->amountToPayForBooking>0)
        //{
            $this->_session->set('paidAmount',$tempLastBookingDetails->amountToPayForBooking);
            $this->_session->set('arrivalDate',$tempLastBookingDetails->arrivalDate);
            $this->_session->set('departureDate',$tempLastBookingDetails->departureDate);
            $this->_session->set('bookingPaymentMode',$tempLastBookingDetails->bookingPaymentMode);
            $this->_session->set('numberOfRooms',$tempLastBookingDetails->numberOfRooms);
            $this->_session->set('numberOfPeople',$tempLastBookingDetails->numberOfPeople);
            $this->_session->set('numberOfChildren',$tempLastBookingDetails->numberOfChildren);
            $this->_session->set('accomodationType',$tempLastBookingDetails->accomodationType);
            $this->_session->set('accomodationTypeName',$tempLastBookingDetails->accomodationTypeName);
            $amountToPay                    = Apputils::fetchSettings('ReserveModeAmount');
            $amountMode                    = Apputils::fetchSettings('ReservePayMode');
            $reserveMode                    = Apputils::fetchSettings('ReserveMode');
            if($reserveMode == 'F'){
                $this->_session->set('paidAmount',0);
                $due = $tempLastBookingDetails->extraPrice;
            }
            else if($reserveMode == 'P'){
            if($amountMode == 'Per'){
                
                $total = ($tempLastBookingDetails->amountToPayForBooking*100)/$amountToPay;
                $due = $total-$tempLastBookingDetails->amountToPayForBooking;
            }
            else if($amountMode == 'Amt')
            {
                $total = $tempLastBookingDetails->amountToPayForBooking+$amountToPay;
                $due = $total-$tempLastBookingDetails->amountToPayForBooking;
            }
            $this->_session->set('amountDueOnCheckin',$due);
            
            }
       // }
        
        

        PageContext::$response->amountToPayForBooking = $this->_session->get('paidAmount');
        PageContext::$response->arrivalDate = $this->_session->get('arrivalDate');
        PageContext::$response->departureDate = $this->_session->get('departureDate');
        PageContext::$response->bookingPaymentMode = $this->_session->get('bookingPaymentMode');
        PageContext::$response->numberOfRooms = $this->_session->get('numberOfRooms');
        PageContext::$response->numberOfPeople = $this->_session->get('numberOfPeople');
        PageContext::$response->numberOfChildren = $this->_session->get('numberOfChildren');
        PageContext::$response->accomodationType = $this->_session->get('accomodationType');
        PageContext::$response->accomodationTypeName = $this->_session->get('accomodationTypeName');
        PageContext::$response->amountDueOnCheckin = $this->_session->get('amountDueOnCheckin');
        //if(PageContext::$response->amountDueOnCheckin <0) PageContext::$response->amountDueOnCheckin=0;
        PageContext::addJsVar('JQ_starting_price', $tempLastBookingDetails->startingPrice);


        $this->_session->delete('last_booking_details');


        if(PageContext::$response->amountToPayForBooking == '' || PageContext::$response->amountToPayForBooking == 0) {
            // $this->redirect('search');

            PageContext::$response->amountToPayForBooking = 0;
        }

    }


    /* post action */
    public function paymentInformation() {

        PageContext::$response->isAuthorizeEnabled             = Apputils::fetchSettings('cenable_authorize');
        PageContext::$response->isPaypalEnabled                = Apputils::fetchSettings('cenable_paypal');
        PageContext::$response->isYorpayEnabled                = Apputils::fetchSettings('enableyourpay');
        PageContext::$response->isWorldpayEnabled              = Apputils::fetchSettings('enableworldpay');
        PageContext::$response->isGooglecheckoutEnabled        = Apputils::fetchSettings('enablegoogle');
        PageContext::$response->isotherOptionsEnabled          = Apputils::fetchSettings('enable_other_payments');
        PageContext::$response->isPaypalProEnabled             = Apputils::fetchSettings('cenable_paypal_pro');
        PageContext::$response->isBluepayEnabled               = Apputils::fetchSettings('enablebluepay');

        PageContext::$full_layout_rendering = false;

        $this->view->disableLayout();

        $currentYear  = (int) date('Y');

        $yearArray    = array();

        PageContext::$response->monthArray   = array('01'=>"January", '02'=>"February", '03'=>"March", '04'=>"April", '05'=>"May", '06'=>"June", '07'=>"July", '08'=>"August", '09'=>"September", '10'=>"October", '11'=>"November", '12'=>"December");


        $currentYear = $currentYear-1;

        for($i=0; $i<10; $i++) {
            $yearArray[] = $currentYear = $currentYear+1;
        }

        PageContext::$response->yearArray = $yearArray;


    }




    /*
      *
      * Ajax functions called from 3 step booking pages
      *
    */




    // ajax fuunction
    public function ajaxBookNow($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfRooms) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        print Booking::getExtraAmount($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfRooms);
        exit();

    }
    
    // ajax fuunction
    public function ajaxAdiitionalguestrate($locationId,$acctype) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $guests=Booking::getAdiitionalguestrate($locationId,$acctype);
        $output= "<span>Number of guests allowed:".$guests[0]->additional_guest_allowed."</span> <br>
            <span> Additional guest rate:".$guests[0]->additional_guest_rate."</span> <br>";
        echo $output;
       // print_r(Booking::getAdiitionalguestrate($locationId,$acctype));
        exit();

    }


    // ajax fuunction
    public function saveBookingDetails($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfChildren,$numberOfRooms) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        print Booking::saveBookingAmount($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfChildren,$numberOfRooms);
        exit();

    }


    // ajax fuunction
    public function saveExpediaBookingDetails($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfChildren,$numberOfRooms,$expediaInfo) {


        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        $siteBookingMode             = Apputils::fetchSettings('ReserveMode'); // P => payment via payment gateways other will be offline payment

        if($siteBookingMode != DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT)  // When site is in offline payment mode...
            $siteBookingMode          = DB_BOOKING_SITE_BOOKING_MODE_FREE_TEXT;

        $bookingPaymentMode         = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
        $amountToPayForBooking = $_REQUEST['rate'];

        $accomadationAvailabilityDetails                               = array();
        $accomadationAvailabilityDetails['locationId']                 = $locationId;
        $accomadationAvailabilityDetails['accomadationType']           = $accomadationType;
        $accomadationAvailabilityDetails['accomadationAvailabilityId'] = $accomadationAvailabilityId;
        $accomadationAvailabilityDetails['numberOfPeople']             = $numberOfPeople;
        $accomadationAvailabilityDetails['arrivalDate']                = $arrivalDate;
        $accomadationAvailabilityDetails['departureDate']              = $departureDate;
        $accomadationAvailabilityDetails['startingPrice']              = $startingPrice;
        $accomadationAvailabilityDetails['extraPrice']                 = $amountToPayForBooking;
        $accomadationAvailabilityDetails['siteBookingMode']            = $siteBookingMode;
        $accomadationAvailabilityDetails['bookingPaymentMode']         = $bookingPaymentMode;
        $accomadationAvailabilityDetails['specialOfferPrice']          = $specialOfferDetails[0];
        $accomadationAvailabilityDetails['groupDiscountPrice']         = $groupDiscountDetails->discount_percentage;
        $accomadationAvailabilityDetails['numberOfChildren']           = $numberOfChildren;
        $accomadationAvailabilityDetails['amountToPayForBooking']      = $amountToPayForBooking;
        $accomadationAvailabilityDetails['numberOfRooms']              = $numberOfRooms;
        $accomadationAvailabilityDetails['apiType']                    = 'Expedia';
        $accomadationAvailabilityDetails['expediaRatekey']                    = $_REQUEST['ratekey'];

        $accomadationAvailabilityDetails['expediaRoomtype']                    = $_REQUEST['roomtype'];
        $accomadationAvailabilityDetails['expediaRatecode']                    = $_REQUEST['ratecode'];
        $accomadationAvailabilityDetails['expediaRate']                    = $_REQUEST['rate'];







        Booking::setSession($accomadationAvailabilityDetails);

        echo $startingPrice.'_'.$amountToPayForBooking;
        exit();

    }




    // Ajax function
    public function editBookingDetails($numberOfPeople,$arrivalDate,$departureDate,$numberOfChildren,$numberOfRooms) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();


        $objSession                       = new LibSession();
        $accomadationAvailabilityDetails  = array();

        $customerDetails                  = json_decode($objSession->get('customer'));
        $cart 		                  = new Cart('customer_cart',$customerDetails->nCust_Id);

        $tempLastBookingDetails           = json_decode($objSession->get('last_booking_details'));

        $locationId                       = $tempLastBookingDetails->locationId;
        $accomadationType                 = $tempLastBookingDetails->accomadationType;
        $startingPrice                    = $tempLastBookingDetails->startingPrice;


        print Booking::saveBookingAmount($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfChildren,$numberOfRooms);
        exit();

    }




    public function proceed() // Without payment
    {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();

        $emailAlreadyExists                 = false;

        $customerDetails                    = json_decode($this->_session->get('customer'));
        $tempEmail                          = PageContext::$request['txtEmail'];


        if($customerDetails->nCust_Id > 0) {


            if(Customer::checkEmailExits($tempEmail,$customerDetails->nCust_Id)) {
                $emailAlreadyExists         = true;
                print 2;
                exit();
            }





            Customer::updateCustomerProfile($customerDetails->nCust_Id,PageContext::$request);


            $post['txtUserName']              = $customerDetails->vLogin;
            $post['txtPassword']              = $customerDetails->vPassword;
            $post['login_remember_me']        = false;

            Customer::doLogin($post);
            $customerId                       = $customerDetails->nCust_Id;
        }
        else {

            if(Customer::checkEmailExits($tempEmail)) {
                $emailAlreadyExists         = true;
                print 2;
                exit();
            }
            else {
                $customerId                  = Customer::addCustomer(PageContext::$request);
            }

        }

        $customerDetails                    = json_decode($this->_session->get('customer'));

        
                
        if(PageContext::$request['bookingMode'] != DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT && PageContext::$request['advance'] > 0) {
// Exicute this section of code when site is not in offline booking mode and the advance amount is greater than 0.
            print 3;
            exit();
        }



        $tempLastBookingDetails         = json_decode($this->_session->get('last_booking_details')); 
        $accomadationType               = $tempLastBookingDetails->accomadationType;
        $accomadationAvailabilityId     = $tempLastBookingDetails->accomadationAvailabilityId;
        $numberOfAdults                 = $tempLastBookingDetails->numberOfPeople;
        //$numberOfChildren               = ''; // dont know why it is assigned null (re-assigned with the real value)
        $numberOfChildren               = $tempLastBookingDetails->numberOfChildren;
        $arrivalDate                    = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','Y-m-d');
        $departureDate                  = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','Y-m-d');
        $extraAmount                    = $tempLastBookingDetails->extraPrice;
        $numberOfRooms                  = $tempLastBookingDetails->numberOfRooms;

        $amountToPay                    = Apputils::fetchSettings('ReserveModeAmount');
        $reserveMode                    = Apputils::fetchSettings('ReserveMode');


        $bookingPaymentMode          = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
        $reservationModeAmount       = $amountToPay;

        if($reservationModeAmount > 0) {

            if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
                $amountToPayForBooking  = $reservationModeAmount;

            else
                $amountToPayForBooking = ($extraAmount * $reservationModeAmount / 100);
        }
        else  // When site is in offline payment mode...
            $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;



        if(PageContext::$request['advance'] > 0) {
            $siteBookingModeText = DB_BOOKING_SITE_BOOKING_MODE_FREE_TEXT;
        }
        else {
            $siteBookingModeText =  DB_BOOKING_SITE_BOOKING_MODE_FREE_TEXT ;
        }

        if($emailAlreadyExists == false) {

            $bookingId      = Booking::recordOrder($customerId,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$tempLastBookingDetails->siteBookingMode,$amountToPayForBooking,$siteBookingModeText,$numberOfRooms,'USERS');
            $bookingDetails = array();

            

            $bookingDetails['arrivalDate']               = $tempLastBookingDetails->arrivalDate;
            $bookingDetails['departureDate']             = $tempLastBookingDetails->departureDate;
            $bookingDetails['nAdults']                   = $tempLastBookingDetails->numberOfPeople;
            $bookingDetails['numberOfChildren']          = $tempLastBookingDetails->numberOfChildren;
            $bookingDetails['amountToPayForBooking']     = $tempLastBookingDetails->amountToPayForBooking;
            $bookingDetails['groupDiscountPrice']        = $tempLastBookingDetails->groupDiscountPrice;
            $bookingDetails['specialOfferPrice']         = $tempLastBookingDetails->specialOfferPrice;
            $bookingDetails['siteBookingMode']           = $tempLastBookingDetails->siteBookingMode;
            $bookingDetails['accomadationType']          = $tempLastBookingDetails->accomadationType;
            $bookingDetails['name']                      = $customerDetails->vFirstname. ' '. $customerDetails->vLastname;
            $bookingDetails['locationName']              = Booking::getLocationName($bookingId);
            $bookingDetails['extraPrice']                = $tempLastBookingDetails->extraPrice;
            $bookingDetails['destinationName']           = Booking::getDestinationName($bookingId);
            $bookingDetails['numberOfRooms']             = $tempLastBookingDetails->numberOfRooms;


            $bookingDetails['firstName']                 = $customerDetails->vFirstname;
            $bookingDetails['lastName']                  = $customerDetails->vLastname;

            $bookingDetails['address']                   = Booking::getLocationAddress($bookingId);





            Booking::sendInvoice($tempEmail,$bookingDetails,'User');
            Booking::sendInvoice($tempEmail,$bookingDetails,'Admin');

            print 1;
        }

        exit();

    }


    /*
 *   Function name : proceedWithPayment
 *   This function do the same as the " proceed " function but consider payment gateways.
    */




    public function proceedWithPayment($payMode) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $objSession                     = new LibSession();

        $customerDetails                = json_decode($this->_session->get('customer'));
        $tempLastBookingDetails         = json_decode($this->_session->get('last_booking_details'));

        $accomadationType               = $tempLastBookingDetails->accomadationType;
        $accomadationAvailabilityId     = $tempLastBookingDetails->accomadationAvailabilityId;
        $numberOfAdults                 = $tempLastBookingDetails->numberOfPeople;
        //$numberOfChildren               = ''; // dont know why it is assigned null (re-assigned with the real value)
        $numberOfChildren               = $tempLastBookingDetails->numberOfChildren;
        $arrivalDate                    = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','Y-m-d');
        $departureDate                  = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','Y-m-d');
        $extraAmount                    = $tempLastBookingDetails->extraPrice;
        $numberOfRooms                  = $tempLastBookingDetails->numberOfRooms;


        $amountToPay                    = Apputils::fetchSettings('ReserveModeAmount');
        $reserveMode                    = Apputils::fetchSettings('ReserveMode');


        $bookingPaymentMode          = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
        $reservationModeAmount       = $amountToPay;

        if($reservationModeAmount>0) {

            if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
                $amountToPayForBooking  = $reservationModeAmount;

            else
                $amountToPayForBooking = ($extraAmount * $reservationModeAmount / 100);
        }
        else  // When site is in offline payment mode...
            $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;


        if($customerDetails->nCust_Id > 0) {


            if($payMode == 5) {
                $payMode = DB_BOOKING_PAY_METHOD_WORLDPAY ;
            }
            else {
                $payMode = ($payMode == 2) ? DB_BOOKING_PAY_METHOD_PAYPAL : DB_BOOKING_PAY_METHOD_AUTHORIZE_NET;
            }

            $bookingId = Booking::recordOrder($customerDetails->nCust_Id,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$tempLastBookingDetails->siteBookingMode,$amountToPayForBooking,$payMode,$numberOfRooms);
            $objSession->set('last_booking_id',$bookingId);

            if($payMode == DB_BOOKING_PAY_METHOD_WORLDPAY)
                print $bookingId;

            else
                print 1;

        }

        exit();

    }






    public function payWithOtherOptions() {
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $objSession                     = new LibSession();

        $customerDetails                = json_decode($this->_session->get('customer'));
        $tempLastBookingDetails         = json_decode($this->_session->get('last_booking_details'));

        $accomadationType               = $tempLastBookingDetails->accomadationType;
        $accomadationAvailabilityId     = $tempLastBookingDetails->accomadationAvailabilityId;
        $numberOfAdults                 = $tempLastBookingDetails->numberOfPeople;

        //$numberOfChildren               = ''; // dont know why it is assigned null (re-assigned with the real value)
        $numberOfChildren               = $tempLastBookingDetails->numberOfChildren;
        
        $arrivalDate                    = Utils::dateFormat($tempLastBookingDetails->arrivalDate,'m-d-Y','Y-m-d');
        $departureDate                  = Utils::dateFormat($tempLastBookingDetails->departureDate,'m-d-Y','Y-m-d');
        $extraAmount                    = $tempLastBookingDetails->extraPrice;
        $numberOfRooms                  = $tempLastBookingDetails->numberOfRooms;



        $amountToPay                    = Apputils::fetchSettings('ReserveModeAmount');
        $reserveMode                    = Apputils::fetchSettings('ReserveMode');


        $bookingPaymentMode          = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
        $reservationModeAmount       = $amountToPay;

        if($reservationModeAmount>0) {

            if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
                $amountToPayForBooking  = $reservationModeAmount;

            else
                $amountToPayForBooking = ($extraAmount * $reservationModeAmount / 100);
        }
        else  // When site is in offline payment mode...
            $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;

        if($customerDetails->nCust_Id > 0) {

            $payMode = PageContext::$request['type'];

            $bookingId = Booking::recordOrder($customerDetails->nCust_Id,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$tempLastBookingDetails->siteBookingMode,$amountToPayForBooking,$payMode,$numberOfRooms);
            $objSession->set('last_booking_id',$bookingId);

            $db = new Db();
            $paymentId = $db->selectRow('payment', 'nPayment_Id', 'nBooking_Id="'.$bookingId.'"');


            $dataArray['paymentId']         = $paymentId;
            $dataArray['payment_mode']      = PageContext::$request['type'];
            $dataArray['name']              = PageContext::$request['name'];
            $dataArray['reference_no']      = PageContext::$request['referenceNumber'];
            $dataArray['bank']              = PageContext::$request['bank'];
            $dataArray['date']              = Utils::dateFormat(PageContext::$request['date'],'m-d-Y','Y-m-d');

            $db->addFields('bank_details', $dataArray);



            print 1;
        }

        exit();
    }



    public function getRateCard($accomadationId) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $this->view->disableView();

        print $costString                   = Location::getRateCard($accomadationId);
        exit();

    }


    /*
 	 * function to make expedia payment
    */
    public function expediapayment_Bkp()	// deprecated
    {

        $expediaSettings = Apisearch::getExpediaSettings();

        // hotel booking parameters
        $bookingInfo  = array();
        $bookingInfo['hotelId'] 		= '125719';
        $bookingInfo['arrivalDate'] 	= '01/05/2013';
        $bookingInfo['departureDate'] 	= '01/07/2013';
        $bookingInfo['room1'] 			= '1';
        $bookingInfo['smoking'] 		= 'NS';
        $bookingInfo['bedTypeID'] 		= '14';
        $bookingInfo['chargeableRate'] 	= '300.83';
        $bookingInfo['Adults'] 			= '2';
        $bookingInfo['Children'] 		= '1';
        $bookingInfo['firstName'] 		= 'Jinson';
        $bookingInfo['lastName'] 		= 'Mathew';
        $bookingInfo['eMail'] 			= 'jinson.m@armiasystems.com';
        $bookingInfo['address1'] 		= 'Test address';
        $bookingInfo['city'] 			= 'Expediapolis';
        $bookingInfo['state'] 			= '';
        $bookingInfo['countryCode'] 	= 'GB';
        $bookingInfo['postCode'] 		= 'Ex1Ex2';
        $bookingInfo['homePhone'] 		= '020123456789';
        $bookingInfo['workPhone'] 		= '020123654789';


        // user card details
        $bookingInfo['ccType'] 			= 'CA';
        $bookingInfo['ccNumber'] 		= '5401999999999999';
        $bookingInfo['expiryMonth'] 	= '09';
        $bookingInfo['expiryYear'] 		= '2015';
        $bookingInfo['ccIdentifier'] 	= '123';


        // code to find the rate key
        $getRateKey = 'http://api.ean.com/ean-services/rs/hotel/v3/avail?minorRev='.$expediaSettings['minorRev'].'&cid='.$expediaSettings['cid'].'&apiKey='.$expediaSettings['apiKey'].'&customerUserAgent=&customerIpAddress=&customerSessionId=&locale='.$expediaSettings['locale'].'&currencyCode='.$expediaSettings['currencyCode'].'&hotelId='.$bookingInfo['hotelId'].'&arrivalDate='.$bookingInfo['arrivalDate'].'&departureDate='.$bookingInfo['departureDate'].'&includeDetails=true&includeRoomImages=true&room1='.$bookingInfo['room1'];
        $info 		= file_get_contents($getRateKey);
        $info 		= json_decode($info);
        $bookingInfo['rateKey'] 	= $info->HotelRoomAvailabilityResponse->rateKey;



        if(sizeof($info->HotelRoomAvailabilityResponse->HotelRoomResponse) > 1) {
            $bookingInfo['roomType'] = $info->HotelRoomAvailabilityResponse->HotelRoomResponse[0]->roomTypeCode;
            $bookingInfo['rateCode'] = $info->HotelRoomAvailabilityResponse->HotelRoomResponse[0]->rateCode;
        }
        else {
            $bookingInfo['roomType'] = $info->HotelRoomAvailabilityResponse->HotelRoomResponse->roomTypeCode;
            $bookingInfo['rateCode'] = $info->HotelRoomAvailabilityResponse->HotelRoomResponse->rateCode;
        }
        // rate key finding code ends
        $bookingInfo['sessionID']    = $info->HotelRoomAvailabilityResponse->customerSessionId;

        $bookData = array(
                "sessionID" 	=> $bookingInfo['sessionID'],
                "currency" 		=> $expediaSettings['currencyCode'],
                "locale" 		=> $expediaSettings['locale'],
                "hotelID" 		=> $bookingInfo['hotelId'],
                "arrivalDate" 	=> $bookingInfo['arrivalDate'],
                "departureDate" => $bookingInfo['departureDate'],
                "supplierType" 	=> "E",
                "rateKey" 		=> $bookingInfo['rateKey'],
                "roomType" 		=> $bookingInfo['roomType'],
                "rateCode" 		=> $bookingInfo['rateCode'],
                "chargeableRate"=> $bookingInfo['chargeableRate'],
                "Adults" 		=> $bookingInfo['Adults'],
                "Children" 		=> $bookingInfo['Children'],
                "ChildAge" 		=> '',
                "firstName" 	=> $bookingInfo['firstName'],
                "lastName" 		=> $bookingInfo['lastName'],
                "bedTypeID" 	=> $bookingInfo['bedTypeID'],
                "smoking" 		=> $bookingInfo['smoking'],
                "eMail" 		=> $bookingInfo['eMail'],
                "address1" 		=> $bookingInfo['address1'],
                "city" 			=> $bookingInfo['city'],
                "state" 		=> $bookingInfo['state'],
                "countryCode" 	=> $bookingInfo['countryCode'],
                "postCode" 		=> $bookingInfo['postCode'],
                "homePhone" 	=> $bookingInfo['homePhone'],
                "workPhone" 	=> $bookingInfo['workPhone']
        );

        //Payment Data from SECURE Payment Forms
        $paymentData = array (
                "firstName" 	=> $bookingInfo['firstName'],
                "lastName" 		=> $bookingInfo['lastName'],
                "ccType" 		=> $bookingInfo['ccType'],
                "ccNumber" 		=> $bookingInfo['ccNumber'],
                "expiryMonth" 	=> $bookingInfo['expiryMonth'],
                "expiryYear" 	=> $bookingInfo['expiryYear'],
                "ccIdentifier" 	=> $bookingInfo['ccIdentifier'],
        );


        $bookingResponse = Booking::doExpediaBooking($bookData, $paymentData,$expediaSettings);
        if ($bookingResponse->processedWithConfirmation == true ) {				// booking is success
            echo "Itinerary number :" . $bookingResponse->itineraryId . "<br>";
            echo "Confirmation Number number :" . $bookingResponse->confirmationNumbers .'<br>';
        }
        else {		// booking is failure
            echo "booking error";
        }

        echo "Out Put";
        echo "<pre>";
        print_r($bookingResponse);




        exit();
    }



    public function ajaxCheckAvailability() {

        $expediaSettings = Apisearch::getExpediaSettings();
        $bookingInfo['hotelId']			= PageContext::$request['location'];
        $bookingInfo['arrivalDate']	= PageContext::$request['arrivaldate'];
        $bookingInfo['departureDate']= PageContext::$request['departuredate'];
        $bookingInfo['room1']= PageContext::$request['numberofrooms'];
        $type = PageContext::$request['type'];
        // code to find the rate key
        $getRateKey = 'http://api.ean.com/ean-services/rs/hotel/v3/avail?minorRev='.$expediaSettings['minorRev'].'&cid='.$expediaSettings['cid'].'&apiKey='.$expediaSettings['apiKey'].'&customerUserAgent=&customerIpAddress=&customerSessionId=&locale='.$expediaSettings['locale'].'&currencyCode='.$expediaSettings['currencyCode'].'&hotelId='.$bookingInfo['hotelId'].'&arrivalDate='.$bookingInfo['arrivalDate'].'&departureDate='.$bookingInfo['departureDate'].'&includeDetails=true&includeRoomImages=true&room1='.$bookingInfo['room1'].'&roomTypeCode='.$type;
       
        $info 		= file_get_contents($getRateKey);
        $info 		= json_decode($info);

        $infoCount = count($info->HotelRoomAvailabilityResponse->HotelRoomResponse);
     
        foreach($info->HotelRoomAvailabilityResponse->HotelRoomResponse as $roomType){
            
            if($roomType->roomTypeCode == $type){
               
                $rateCode = $roomType->rateCode;
                $arrHotelInfo = get_object_vars($roomType->RateInfo->ChargeableRateInfo);
                $rate= $arrHotelInfo['@total'];
               
            }
        }
       
       
        $params 	= 'ratekey='.$info->HotelRoomAvailabilityResponse->rateKey;

        if($infoCount >= 1) {


            $params .= '&roomtype='.$type;
            $params .= '&ratecode='.$rateCode;

           // $arrHotelInfo = get_object_vars($info->HotelRoomAvailabilityResponse->HotelRoomResponse[0]->RateInfo->ChargeableRateInfo);
            $params .= '&rate='.$rate*PageContext::$request['numberofrooms'];


            $result = 'result=success&'.$params;
        }else
            $result = 'result=error&msg='.$info->HotelRoomAvailabilityResponse->EanWsError->verboseMessage;


        echo $result;
        exit();
    }



}

?>
