<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Santhosh Thomas Alexander<santhosh.thomas@armiasystems.com> |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com  2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "includes/config.php";
include "includes/session.php";
include "includes/functions.php";
include_once "classes/cls_cart.php";
include_once "classes/cls_products.php";
include_once "classes/cls_user.php";
include_once "classes/cls_combopack.php";

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}
if (isset($_SESSION["sess_userid"]) and $_SESSION["sess_userid"] != "") {
    $userid = $_SESSION["sess_userid"];
}


if (checkGiftProductsExistsinCart($userid)) {
    cartClearDigital($userid);
}



$_SESSION["sess_addresses_collected"] = false;

if (isset($_GET["msg"]) and ($_GET["msg"] != "")) {
    $msg = $_GET["msg"];
    switch ($msg) {
        case "updateqty": $message = UPDATE_QUANTITY_ERROR_MSG."<br>";
            break;
        case "cart_error_nondigital": $message = CART_ERROR_NONDIGITAL_MSG."<br>";
            break;
        case "cart_error_digital": $message = CART_ERROR_DIGITAL_MSG."<br>";
            break;
        case "cart_stock_less": $message = CART_STOCK_LESS_MSG."<br>";
            break;
         case "no_permission": $message = NO_PERMISSION_PURCHASE_PRODUCT."<br>";
            break;
        default:
            ;
    } // switch
}


if (isset($_GET['action']) && $_GET['action'] == 'checkout') {

    header("Location:checkout.php");
    exit;
}


$res = $pdo->select($tableprefix."settings",array("enable_free_shipping","min_order_amount"))->results();

if(!empty($res))

{
    $row = $res[0];
    $freeShipEnable = $row['enable_free_shipping'];
    $freeShipOrderAmt = $row['min_order_amount'];
    
}

if (isset($_POST["btnDeleteSelected"])) {
    $items = $_POST["chkitems"];
    $combo_items=$_POST['chkcomboitems'];
//    print_r($combo_items);exit;
    if (!isNotNull($items) && !isNotNull($combo_items)) {
        $message = NO_ITEMS_SELECTED_MSG."<br>";
    }
    if ($message != "") { // error
        $message = "<br>".CORRECT_ERRORS_TEXT."<br>" . $message;
    } else {
        if(!empty($items))
        {
        $items = implode(",", $items);
         list($qarr,$qstr) = getInQueryString($items);
        $sql = "DELETE FROM " . $tableprefix . "cart WHERE cart_id IN (" . $qstr . ") ";
        $pdo->pdoQuery($sql,$qarr)->affectedRows();
        }
        if(!empty($combo_items))
        {
            foreach($combo_items as $combo_id)
            {
            $combo_cart_ids=$_POST['txt_combo_cart_map_'.$combo_id];
              list($qarr,$qstr) = getInQueryString($combo_cart_ids);      
             $sql = "DELETE FROM " . $tableprefix . "cart WHERE cart_id IN (" . $qstr . ") ";
        $pdo->pdoQuery($sql,$qarr)->affectedRows();       
            }      
        }
        
       
        $message = DELETE_SUCESSFUL_MSG;
       
    }
} else if (isset($_POST["btnUpdateQuantities"])) {
   if(isset($_POST["cartitems"]) && $_POST["cartitems"]!=''){
    $cartitems = $_POST["cartitems"];
    $allnotupdated = false;
    $arrcartitems = explode(",", $cartitems);
     list($qarr,$qstr) = getInQueryString($cartitems);
    $sql = "SELECT * FROM " . $tableprefix . "cart WHERE cart_id IN (" . $qstr. ") ";
    $result = $pdo->pdoQuery($sql,$qarr)->results(); 
    $parr = array();
    $poarr = array();
    if (!empty($result)) {
        foreach($result as $key=>$row){
            $cid = $row["cart_id"];
            $parr[$cid] = $row["product_id"];
            $poarr[$cid] = $row["product_option_id"];
        }
    }
    $qtyadjusted = false;
    for ($i = 0; $i < count($arrcartitems); $i++) {
        $var = "txtQuantity_" . $arrcartitems[$i];
        $cartid = $arrcartitems[$i];
        $value = intval($_POST["$var"]);        
        $noFloat = ($value==$_POST["$var"])?1:0;      
      
        if ($value > 0 && $noFloat==1) {
            $product_id = $parr[$cartid];
            $product_option_id = $poarr[$cartid];
            $qtyavailable = getProductStock($product_option_id);
            if ($value > $qtyavailable) {
                $value = $qtyavailable;
                $qtyadjusted = true;
            }
           
            $q = $pdo->update($tableprefix.'cart', array('quantity' =>$value), array('cart_id'=>$cartid))->affectedRows();

        } else {
            $allnotupdated = true;
        }
    }
}
    //////////////////////////////////////////////
    
    if(isset($_POST["cartcombo_items"]) && $_POST["cartcombo_items"]!='')
    {
        $cart_combo_items=$_POST["cartcombo_items"];
        
        $arrcart_comboitems = explode(",", $cart_combo_items);
        foreach($arrcart_comboitems as $combo_id){
             $var = "txtQuantity_combo_" . $combo_id;
        $combo_available=  ComboPack::get_available_combo_quantity($combo_id);
        $requested_quantity = intval($_POST["$var"]); 
        if($requested_quantity>$combo_available)
        {
            $requested_quantity=$combo_available;
            $qtyadjusted=true;
        }
        
//        $noFloat = ($requested_quantity==$_POST["$var"])?1:0;   
            if ($requested_quantity > 0) {
                if(ComboPack::validate_stock_availablity($combo_id, $requested_quantitiy))
                {
                   if(ComboPack::check_combo_items_available_in_stock($combo_id, $requested_quantitiy))
                   { 
                      $combo_products=  explode(",",$_POST["txt_combo_products_map_".$combo_id]);//ComboPack::get_combo_products($combo_id);
                      $combo_cartids=  explode(",",$_POST["txt_combo_cart_map_".$combo_id]);
//                      print_r($combo_cartids);exit;
//                      print_r($_POST['txt_combo_cart_map_'.$combo_id]);EXIT;
                      foreach($combo_products as $index=>$product_option_id)
                      {
//                          echo $index;echo $combo_cartids[$index];echo $product_option_id;echo $combo_id;exit;
//                          $product_id = $combo_product_single['product_id'];
//                        $product_option_id = $product_option_id;//$combo_product_single['product_option_id'];
//                        $product_quantity= //$combo_product_single['product_quantity'];
                            $product_quantity=  ComboPack::get_product_quantity($combo_id, $product_option_id);
                            $cart_id=$combo_cartids[$index];
                            $quantity=$requested_quantity*$product_quantity;
//                             echo $quantity.'---'.$cartid.'---'.$combo_id.'----'.$product_option_id;exit;
                         $q = $pdo->update($tableprefix.'cart', array('quantity' =>$quantity), array('cart_id'=>$cart_id,'combo_id'=>$combo_id,'product_option_id'=>$product_option_id))->affectedRows();

                      }
                   }
                   else
                   {
                       $allnotupdated = true;
                   }
                
                }
            else {
                $allnotupdated = true;
            }
                
            }
            else
            {
                 $allnotupdated = true;
            }
            
        }
    }
    
    //////////////////////////////////////////////////

    if ($allnotupdated) { // error
        $message .= "<br>".ALL_NOT_UPDATED_MSG;
    }
    if ($qtyadjusted) { // error
        $message .= "<br>".QUANTITIES_ADJUSTED_MSG;
    }
    if ($message == "") { // all done
        $message = UPDATE_SUCESSFUL_MSG;
    }
} else if (isset($_POST["btnCheckout"])) {

    $row_paypal_result = $pdo->select($tableprefix."settings",array("enable_buyerToseller"),'')->results(); 
    if($row_paypal_result) $row_paypal = $row_paypal_result[0];
    if (!isset($_SESSION["sess_userid"]) and $_SESSION["sess_userid"] == "") {

        $cartitems = $_POST["cartitems"];
        $arrcartitems = explode(",", $cartitems);

        for ($i = 0; $i < count($arrcartitems); $i++) {

            $var = "txtQuantity_" . $arrcartitems[$i];
            $insert_cart_temp = $pdo->insert($tableprefix."cart_temp",array("ncart_id"=>$arrcartitems[$i],"ncart_quantity"=>$_POST["$var"]))->affectedRows();
            
        }
//        print_r($_POST);exit;
        if(isset($_POST['cartcombo_items']))
        {
            $combo_ids=explode(",", $_POST['cartcombo_items']);
            foreach($combo_ids as $combo_id)
            {
                $combo_quantity=$_POST['txtQuantity_combo_'.$combo_id];
                $combo_products=  explode(",",$_POST["txt_combo_products_map_".$combo_id]);//ComboPack::get_combo_products($combo_id);
                $combo_cartids=  explode(",",$_POST["txt_combo_cart_map_".$combo_id]);
                
                foreach($combo_products as $index=>$product_option_id)
                      {
                            $product_quantity=  ComboPack::get_product_quantity($combo_id, $product_option_id);
                            $cart_id=$combo_cartids[$index];
                            $quantity=$combo_quantity*$product_quantity;
                            $insert_cart_temp = $pdo->insert($tableprefix."cart_temp",array("ncart_id"=>$cart_id,"ncart_quantity"=>$quantity))->affectedRows();
                      }
            }
        }
    }


    if ($row_paypal["enable_buyerToseller"] == "Y") {
        if (isset($_POST['sellerid'])) {

            $sellerid = $_POST['sellerid'];

            $sellercount = count(array_unique($sellerid));
            //exit;

            if ($sellercount > 5) { 

                header("Location:viewcart.php?msg=duplicate");

                exit;
                //echo "You have to select Only One Sellers Products ";
            }
        }
    }


    header("Location:checkout.php");
    exit;
}

$active_template = displayTemplate();


include "includes/htmltop.php";

/* Top File Name */

include_once ("includes/" . $active_template[0]);


//****************************************************Multicart3.0 Modifications*****************************
 if($_SESSION["sess_userid"]!='')  {
                            //Check the product is logged users product
                            $sellerAccObj   =    User::is_seller_account_activated($_SESSION["sess_userid"]);
                                  //echopre($sellerAccObj);
                                if($sellerAccObj->status==SUCCESS)
                                    {
                                            $sellerAccObjVal            =   $sellerAccObj->data;
                                            $seller_activated_status    =   $sellerAccObjVal->is_seller;
                                            $activated_seller_id        =   $sellerAccObjVal->seller_id;

                                    }
          // Check logged sellers product exist in cart // if single account enabled for buyer and seller

            $sellerCartObj      =    Cart::getCartCountBySellerId($_SESSION["sess_userid"],$visitorId,$activated_seller_id);
       //     echopre($sellerCartObj);
            if($sellerCartObj->status==SUCCESS)
                    {
                         $sellerCartObjVal      =   $sellerCartObj->data;

                         $samesellerItemCount   =   $sellerCartObjVal->selleritemCount;
                    }
                    
            //Hide showing same message multiple times        
                 if(($samesellerItemCount>0) && ($_REQUEST['msg']=='no_permission'))
                 {
                     $message = '';
                 }

            }

//**********************************************Multicart3.0  Modifications**********************************
?>
<script>
    //window.location = "./viewcart.php";
		
    function checkOutCart()
    {
        var sameSellerItemCount     =   '<?php echo $samesellerItemCount;?>';
        var cntt = document.getElementById("cntt").value;
        var c = 0;
        for(i=1;i<=cntt;i++)
        {
            var textval = document.getElementById("txtQuantity_"+i).value;
            var hidval  = document.getElementById("hdQty_"+i).value;
            if(textval == hidval)
            {
                c=c+0;
            }
            else
            {
                c=c+1;
            }
        }
        if(c>0)
        {
            alert("<?php echo UPDATE_ALERT_TEXT; ?>");
            return false;
        }else if(sameSellerItemCount>0) {
            alert("<?php echo NO_PERMISSION_PURCHAPRODUCT_TAG_TEXTSE_MARKED_PRODUCT;?>");
            return false;
        }
        else
        {
            return true;
        }
    }
</script>	
<!--mainbody area start -->
<div class="main_body">
	<div class="container">
		<div class="row">
    	<!--center content area start-->		
		<section class="sec_marg">
		<div class="col-sm-12 col-lg-12 col-md-12 ">
			<h3><?php echo SHOPPING_CART_TEXT; ?></h3>
		</div>
		</section>
		<div class="clear"></div>
		<div class="col-sm-12 col-lg-12 col-md-12 ">
    	<form name="frmCart" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES, 'UTF-8') ?>" method="POST">
        <div align="left" id="item_details">
            <!--items display area start -->

            
            <?php
if ($_GET['msg'] == 'same_seller') {
    ?>
                <div class="text_information" align="center"><?php echo SAME_SELLER_PRODUCT; ?></div>
<?php } ?>
            
            
<?php
if ($_GET['msg'] == 'duplicate') {
    ?>
                <div class="text_information" align="center"><?php echo IF_DUPLICATE_TEXT_INFO; ?></div>
<?php } ?>
            <div class="text_information" align="center"><?php echo $message ?></div>


            <div>



<?php
$total = 0;
$cartitems = "";


if (isset($_SESSION["sess_userid"]) and $_SESSION["sess_userid"] != "") {
    $sql_cart = "SELECT c.*, p.product_name,(p.product_price+po.additional_price) AS product_price,po.discount,p.vdigital_product,p.product_id,p.product_artist_id
						 FROM " . $tableprefix . "cart c
                                                 INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
                                                 INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
                                                 WHERE c.user_id = :userid";
    $argArray = array("userid"=>$_SESSION["sess_userid"]);
} else {
    $sql_cart = "SELECT c.*, p.product_name,(p.product_price+po.additional_price) AS product_price,po.discount,p.product_artist_id
						FROM " . $tableprefix . "cart c 
                                                INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
                                                INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
                                                WHERE  c.visitor_cart_id = :visitor_cart_id ";
     $argArray = array("visitor_cart_id"=>session_id());
}



$res_cart = $pdo->pdoQuery($sql_cart,$argArray)->results();

if (!empty($res_cart)) {
    foreach($res_cart as $rw_cart)
    {
        if (isset($_SESSION["sess_userid"]) and $_SESSION["sess_userid"] != "") {
                
            if ($rw_cart['gift_product_flag']=='Y' ) {
               
                $delObj     =    Cart::clearNonGiftItemsinCart($_SESSION["sess_userid"],session_id());
              
            }
        }
        $_SESSION['gift_certificate_flag'] = $rw_cart['gift_product_flag'];
    }
}


if (isset($_SESSION["sess_userid"]) and $_SESSION["sess_userid"] != "") {
    $sql = "SELECT c.*, p.product_name,(p.product_price+po.additional_price) AS product_price,po.discount,p.product_artist_id
					FROM " . $tableprefix . "cart c
                                        INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
                                        INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
					WHERE c.user_id = '" . addslashes($_SESSION["sess_userid"]) . "'";
    $argArray = array("userid"=>$_SESSION["sess_userid"]);
} else {
    $sql = "SELECT c.*, p.product_name,(p.product_price+po.additional_price) AS product_price,po.discount,p.product_artist_id
					FROM " . $tableprefix . "cart c
                                        INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
                                        INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
                                        WHERE c.visitor_cart_id = '" . addslashes(session_id()) . "' ";
    $argArray = array("visitor_cart_id"=>session_id());
}
$res = $pdo->pdoQuery($sql,$argArray)->results();

$combo_items=array();
$combo_crt_id_map='';
foreach ($res as $index=>$prd) {
    if($prd['combo_id']!='')
    {
        $combo_items[$prd['combo_id']]['prd_name'][$prd['product_option_id']]=$prd['product_name'];
        $combo_items[$prd['combo_id']]['prd_qty'][$prd['product_option_id']]=$prd['quantity'];
       $selectCase = array("product_id" => $prd['product_id'],"product_option_id"=>$prd['product_option_id'],"combo_id"=>$prd['combo_id']);
            $result = $pdo->select($tableprefix . "combo_products", "product_quantity", $selectCase)->results();
//            print_r($result[0]["product_quantity"]);exit;
            $combo_quantity=$prd['quantity']/$result[0]["product_quantity"];
            $combo_items[$prd['combo_id']]['quantity']=$combo_quantity;
            
             if(isset($combo_items[$prd['combo_id']]['productoptionids']))
            {
                $combo_items[$prd['combo_id']]['productoptionids'].="," .$prd['product_option_id'];
            }
            else {
                $combo_items[$prd['combo_id']]['productoptionids']=$prd['product_option_id'];
            }
            
            if(isset($combo_items[$prd['combo_id']]['cartids']))
            {
                $combo_items[$prd['combo_id']]['cartids'].="," .$prd['cart_id'];
            }
            else {
                $combo_items[$prd['combo_id']]['cartids']=$prd['cart_id'];
            }
//            $combo_crt_id_map .= "," . $prd["cart_id"];
//        $combo_items[]
//        unset($res[$index]);
    }
}
//print_r($combo_items);
//echo '------------------------------------------';
$combo_details=array();
foreach($combo_items as $index=>$combos)
{
    
   $combo_details[$index] =  ComboPack::get_combo_details($index);
   $combo_details[$index]['required_quantity']=$combo_items[$index]['quantity'];
}


//print_r($combo_details);exit;


//***********************Multicart3.0 Addition***********************************************

//check digital products count in cart
 if($_SESSION["sess_userid"]!='') 
     {
         $visitorId     =  '';
     }else{
         $visitorId     = generalMethods::sessionid();
     }

 $objDigitalCart                        =     Cart::getDigitalItemsCartCount($_SESSION["sess_userid"],$visitorId);
 if($objDigitalCart->status==SUCCESS)
 {
        $cartDigitalObjVal         =    $objDigitalCart->data;
        $cartDigitalCount          =    $cartDigitalObjVal['digitalcount'];  
 }

//***********************Multicart3.0 Addition****************************************************                


if (!empty($res)) {
    ?>		

                <div class="table-responsive" style="padding-bottom: 0px;">
                            <table width="100%"  border="0" cellspacing="1" cellpadding="6" class="table table-bordered">
                                <tr class="shopcart_heads">
                                    <td width='4%'>&nbsp;</td>
                                    <td width='39%'><?php echo PRODUCTS_TEXT; ?></td>
                                    <td width='19%'><?php echo QUANTITY_TEXT; ?></td>
                                    <td width='22%'><?php echo RATE_TEXT; ?></td>
                                    <td width='16%'><?php echo PRICE_TEXT; ?></td>
                                </tr>

                                <?php if($samesellerItemCount>0) { ?>
                                 <tr>
                                     <td colspan="5" class="warning"> <?php echo NO_PERMISSION_PURCHAPRODUCT_TAG_TEXTSE_MARKED_PRODUCT;?></td>
                                    
                                </tr>
                                <?php } ?>
                             <?php if($cartDigitalCount>0)   { ?> 
                                <tr>
                                    <td></td>
                                    <td width="30%"><img src="<?php echo SITE_URL?>/images/digital_icon.png" alt="<?php echo DIGITAL_PRODUCT_FLAG;?>" title="<?php echo DIGITAL_PRODUCT_FLAG;?>"> &nbsp;&nbsp; <?php echo DIGITAL_PRODUCT_MARK_TEXT;?></td>
                                    <td colspan="3"><!--<img src="<?php echo SITE_URL?>/images/subscription_icon.jpg" alt="<?php echo SUBSCRIPTION_PRODUCT_FLAG;?>" title="<?php echo SUBSCRIPTION_PRODUCT_FLAG;?>"> &nbsp;&nbsp; <?php echo SUBSCRIPTION_PRODUCT_MARK_TEXT;?>--></td>
                                </tr>
                             <?php } ?>
                                
                                


                    <?php
                    $cntt = 0;
                    $currency_attributes = displayCurrencyType();
                    $flag_single_account_flag   =   '';
                    foreach($res as $rw) { 
                        
        $row_style=($rw['combo_id']!='')?'display:none':'';
                        $productname = $rw["product_name"];
                        $product_option_id = $rw["product_option_id"];
                        $check = "<input type='checkbox' class='checkbox' name='chkitems[]' value='" . $rw["cart_id"] . "' > ";

                        $qtytextbox = "<input type='text' id='txtQuantity_" . $cntt . "' name='txtQuantity_" . $rw["cart_id"] . "' value='" . $rw["quantity"] . "' size='1' maxlength='3' class='textbox qty_txtbox form-control'> ";

                        /* ------------Multicart 2.0 Upgradation------------ */

                        // Currency Conversion 

                        $conversionRate = ConvertedCurrencyRate($currency_attributes[2]);//  

                        $converted_price = $rw['product_price'] * $conversionRate;

                        $rate = $converted_price;
                        // End currency Conversion
                        /* ------------Multicart 2.0 Upgradation------------ */

                        $qty = $rw["quantity"];
                        $price = $qty * $rate;
                        $discountstr = "";
                        $discountprice = 0;
                        if ($rw["discount"] != "0") {
                            $price = number_format($price, 2, ".", "");
                            $discountprice = $rate - ($rate * $rw["discount"]) / 100;
                            $discountprice = number_format($discountprice, 2, ".", "");
                            $discountrate = ($discountprice * $qty);
                            $price = $discountrate;
                            $discountstr = "<br>".strtolower(MAIL_ORDER_TEXT_DISCOUNT)."(" . $rw["discount"] . "%)";
                        }
                        $optionVal = getProductOptionsName($product_option_id);
                        if ($optionVal != "") {
                            $optionsStr = "<br>" . $optionVal;
                        }
                  if($rw['combo_id']==''){
                        $total += $price;
                        $cntt++;
                  }
                        
                        
                        //*************Multicart3.0 Additions Check cart item is digital product or not 
                        
                        $objRow     =   Cart::isDigitalIteminCart($rw['cart_id']);
                      
                        if($objRow->status==SUCCESS)
                        {
                            $digitalFlag  = $objRow->data; 
                        }
                        //*************Multicart3.0 Additions Check cart item is subscription product or not 
                        
                        $objSubRow     =   Cart::isSubscriptionIteminCart($rw['cart_id']);
                      
                        if($objSubRow->status==SUCCESS)
                        {
                            $subscriptionFlag  = $objSubRow->data; 
                        }  
                     
                        // Free ship text display 
                        
                        $freeship_flag_text    =   Products::check_free_ship_product_text($rw["product_id"]);
                                               
                        // Mark same seller items in cart to remove // Applicable if single account for seller and buyer

                            if($activated_seller_id==$rw['seller_id'])
                            {
                                 $flag_single_account_flag_class   =   'tr_bg_warning';
                            }
                            else{
                                $flag_single_account_flag_class   =   '';
                            }
                        
                           if($rw['combo_id']=='') {
                        ?>				
                                    <input type="hidden" value="" name="txtQty_<?php echo $cntt; ?>" id="txtQty_<?php echo $cntt; ?>" />
                                    <input type="hidden" value="<?php echo $rw["quantity"]; ?>" name="hdQty_<?php echo $cntt; ?>" id="hdQty_<?php echo $cntt; ?>" />
                                    <tr class="<?php echo $flag_single_account_flag_class;?>" style="<?php echo $row_style; ?>">
                                        <td width='4%'  align="center" valign="top"><?php echo $check ?></td>
                                        <td align='left'><?php if($digitalFlag=='Y') { ?><img src="<?php echo SITE_URL?>/images/digital_icon.png" alt="<?php echo DIGITAL_PRODUCT_FLAG;?>" title="<?php echo DIGITAL_PRODUCT_FLAG;?>"> &nbsp;<?php } ?>
                                                   <!--<?php  /*elseif($subscriptionFlag == 'Y'){*/ ?><img src="<?php echo SITE_URL?>/images/subscription_icon.jpg" alt="<?php echo SUBSCRIPTION_PRODUCT_FLAG;?>" title="<?php echo SUBSCRIPTION_PRODUCT_FLAG;?>"> &nbsp;<?php //} ?> -->
                                                     <?php echo stripslashes($productname) . $discountstr . $optionsStr ; ?> <span class="freeship_text"> <?php echo $freeship_flag_text;?> </span></td>
                                        <td align='left'><?php echo $qtytextbox ?></td>
                                        <td align='left'>
                                    <?php if ($rw["discount"] != "0") {
                                        ?>
                                        <?php echo $currency_attributes[0] . "&nbsp;" . $discountprice; ?>
                                                &nbsp;
                                                ( <strike><?php echo $currency_attributes[0] . "&nbsp;" . number_format($rate, 2, ".", ""); ?></strike>)

                                        <?php
                                    } else {
                                        ?>
                                        <?php echo $currency_attributes[0] . "&nbsp;" . number_format($rate, 2, ".", ""); ?>
                                    <?php } ?>
                                    </td>
                                    <td align='left'>
                                    <?php echo $currency_attributes[0] . "&nbsp;" . number_format($price, 2, ".", ""); ?></td>
                                    <input type='hidden' value='<?php echo $rw["product_artist_id"] ?>' name='sellerid[]'>
                                    </tr>

                                    <?php
                                    }
                                    if($rw['combo_id']==''){
                                    $cartitems .= "," . $rw["cart_id"];
                                    }
                                    //if click continue shopping its redirect to corresponding category
                                    //store last added product category
                                    if (trim($redirect) == '') {
                                        $redirect = $rw["product_category"];
                                    }//end if
                                }
                                $cartcombo_items ='';
//                                print_r($combo_details);exit;
                               foreach ($combo_details as $combo) { 
                                   $cartcombo_items .= "," . $combo["combo_id"];
                                   $cntt++;
                                   $price=$combo["price"];
                                   $combo_products='';
                                   foreach ($combo_items[$combo["combo_id"]]['prd_name'] as $index=>$prd_name) {
                                       $combo_products.='<div class="col-xs-9 col-md-8">'.$prd_name.' <i>-'.$combo_items[$combo["combo_id"]]['prd_qty'][$index].' Item</i></div>';
                                   }
                                   
//                                   $total += $price;
                                   $check = "<input type='checkbox' class='checkbox combo' name='chkcomboitems[]' value='" . $combo["combo_id"] . "' > ";
                                   $qtytextbox = "<input type='text' id='txtQuantity_combo_" . $cntt . "' name='txtQuantity_combo_" . $combo["combo_id"] . "' value='" . $combo["required_quantity"] . "' size='1' maxlength='3' class='textbox qty_txtbox form-control'> ";
                                   $combo_cart_map="<input type='hidden' id='txt_combo_cart_map_" . $cntt . "' name='txt_combo_cart_map_" . $combo["combo_id"] . "' value='" . $combo_items[$combo["combo_id"]]['cartids'] . "' size='1' maxlength='3' class='textbox combo_cart_txtbox'> ";
                                   $combo_products_map="<input type='hidden' id='txt_combo_products_map_" . $cntt . "' name='txt_combo_products_map_" . $combo["combo_id"] . "' value='" . $combo_items[$combo["combo_id"]]['productoptionids'] . "' size='1' maxlength='3' class='textbox combo_products_txtbox'> ";

                                   $digitalFlag='N';
                                    $discountstr='';
                                    $optionsStr='';
                                    $productname=$combo["combo_name"];
                                     $conversionRate = ConvertedCurrencyRate($currency_attributes[2]);
//                                     print_r($conversionRate);exit;
                        $converted_price = $combo["required_quantity"]*$price * $conversionRate;

                        $rate = $converted_price;
                        $freeship_flag_text='';
                         $total += $converted_price;
                                    
                                   
                                   if($activated_seller_id==$combo['seller_id'])
                                    {
                                         $flag_single_account_flag_class   =   'tr_bg_warning';
                                    }
                                    else{
                                        $flag_single_account_flag_class   =   '';
                                    }
                                   
                                   ?>
                                    
                               		
                                    <input type="hidden" value="" name="txtQty_<?php echo $cntt; ?>" id="txtQty_<?php echo $cntt; ?>" />
                                    <input type="hidden" value="<?php echo $combo["quantity"]; ?>" name="hdQty_<?php echo $cntt; ?>" id="hdQty_<?php echo $cntt; ?>" />
                                    <tr class="<?php echo $flag_single_account_flag_class;?>">
                                        <td width='4%' align="center" valign="top" ><?php echo $check ?></td>
                                        <td align='left'><?php if($digitalFlag=='Y') { ?><img src="<?php echo SITE_URL?>/images/digital_icon.png" alt="<?php echo DIGITAL_PRODUCT_FLAG;?>" title="<?php echo DIGITAL_PRODUCT_FLAG;?>"> &nbsp;<?php } ?>
                                                   <!--<?php  /*elseif($subscriptionFlag == 'Y'){*/ ?><img src="<?php echo SITE_URL?>/images/subscription_icon.jpg" alt="<?php echo SUBSCRIPTION_PRODUCT_FLAG;?>" title="<?php echo SUBSCRIPTION_PRODUCT_FLAG;?>"> &nbsp;<?php //} ?> -->
                                                     <?php echo stripslashes($productname). $discountstr . $optionsStr ; ?> <span class="freeship_text"> <?php echo '( Combo pack )'; ?> </span>
                                                    <div class="clearfix"></div>
                                                    <div class="row"><?php echo $combo_products; ?></div>
                                        </td>
                                        <td align='left'><?php echo $qtytextbox.$combo_cart_map.$combo_products_map ?></td>
                                        <td align='left'>
                                    
                                        <?php echo $currency_attributes[0] . "&nbsp;" . number_format($price, 2, ".", ""); ?>
                                    </td>
                                    <td align='left'>
                                    <?php echo $currency_attributes[0] . "&nbsp;" . number_format($rate, 2, ".", ""); ?></td>
                                    <input type='hidden' value='<?php echo $combo["seller_id"] ?>' name='sellerid[]'>
                                    </tr>
                                
                                
                               <?php  } ?>
                                
                                <?php
                                
                                $cartitems = substr($cartitems, 1);
                                $cartcombo_items=substr($cartcombo_items, 1);
                              
                                if($freeShipEnable=="Y"){
                                    $freeshipAmt = round($freeShipOrderAmt);
                                    if(round($total)>=$freeshipAmt){
                                       $freeShipOrderMSg = ORDER_QUALIFIES_FREE_SHIPPING;
                                        
                                    }else{
                                        $freeShipOrderMSg = ORDER_FREE_SHIPPING_AVAILABLE.' '.$currency_attributes[0].''.$freeShipOrderAmt;
                                    }
                                }
                                
                                ?>			
                                <input type="hidden" value="<?php echo $cntt ?>" id="cntt" name="cntt">
                                <tr>
                                    <td  colspan='4' align='right' class="total_td_left"><?php echo TOTAL_TEXT;?>&nbsp;</td>
                                    <td align='left' class="total_td_right"><?php echo $currency_attributes[0] . "&nbsp;" . number_format($total, 2, ".", "") ?></td>
                                </tr>
                                <?php if($freeShipOrderMSg!=''){ ?>
                                <tr>
                                    <td align="center" class="total_td_left" colspan="5" style=" background: #f0f0f0 none repeat scroll 0 0;
                                        font-size: 11px;
                                        font-weight: bold;
                                        padding: 2px;
                                        text-align: center;"><?php echo $freeShipOrderMSg; ?> 
                                    </td>
                                </tr>
                                <?php } ?>

                                       
                        </table>
                        <div class="clear"></div>
                    </div>
						<div class="cart_view_btm">
							<div class="row">
            					<div class="col-xs-12 col-sm-6 col-lg-6 col-md-6 ">
                                                    
                                                     
                                                    	 <input type='hidden' value='<?php echo $cartcombo_items ?>' name='cartcombo_items'>
							 <input type='hidden' value='<?php echo $cartitems ?>' name='cartitems'>
                                                         <input type='submit' value='<?php echo DELETE_SELECTED_BUTTON; ?>' name='btnDeleteSelected' class='cart_dltbtn'>
                                                        <!----Multicart 2.0 starts---->	
                                                        <input type='submit' value='<?php echo UPDATE_QUANTITIES_BUTTON; ?>' name='btnUpdateQuantities' class='cart_updtbtn'>
                                                        <!----Multicart 2.0 ends---->	
                                                </div>
								<div class="col-xs-12 col-sm-6 col-lg-6 col-md-6 ">
									<?php echo "<input type='submit' value='".CHECKOUT_BUTTON."' name='btnCheckout'  id='btnCheckout' class='button checkoutbtn' onClick='return checkOutCart()'>"; ?>
									<input type='button' class='cart_contshopbtn'  value='<?php echo CONTINUE_SHOPPING_BUTTON;?>' onClick='window.location.href="categorydetail.php?catid="<?php echo $redirect;?>'>
								</div>
							</div>
								<?php
                            } else {

                                echo "<table class=\"emptycart\" width=\"100%\"  border=\"0\" cellspacing=\"1\" cellpadding=\"0\">";
                                echo "<tr class=\"text_information\"><td width='100%' align='center'><h4>".CART_EMPTY_MSG."</h4></td></tr>";
                                echo "<tr class=\"whitebg\"><td width='100%' >&nbsp;</td></tr>";
                                echo "<tr class=\"whitebg\"><td width='100%' align='center'><input type='button' class='button'  value='".CONTINUE_SHOPPING_BUTTON."' onClick='window.location.href=\"index.php\"'></td></tr></table>";
                            }
                            ?>
						</div>
            </div>	
            <!--items display area end -->
    </form>
	</div>
    <!--center content area end-->	
    <div align="left" class="clear"></div>	
		
	</div>
	</div>
</div>
<!--mainbody area end -->
<div align="left" class="clear"></div>
<?php
include "includes/" . $active_template[2]; /* Bottom File Name */
?>
