DROP TABLE IF EXISTS `multicart_language_master`;
CREATE TABLE `multicart_language_master` (
    `nlanguageId` INT(10) NOT NULL AUTO_INCREMENT,
    `languageName` VARCHAR(50) NOT NULL DEFAULT '0',
    `prevLanguage` VARCHAR(50) NULL DEFAULT '0',
    `langActive` ENUM('0','1') NULL DEFAULT '0',
    `langDeleteStatus` ENUM('0','1') NULL DEFAULT '0',
    PRIMARY KEY (`nlanguageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

ALTER TABLE `multicart_language_master` CHANGE COLUMN `prevLanguage` `prevLanguage` VARCHAR(50) NULL DEFAULT '0' AFTER `languageName`;

ALTER TABLE `multicart_language_master` ADD COLUMN `backupFile` VARCHAR(500) NULL DEFAULT '0' AFTER `prevLanguage`;

ALTER TABLE `multicart_fedexsettings` ADD COLUMN `FedexPassword` varchar(50) default NULL AFTER `FedexService`;

ALTER TABLE `multicart_fedexsettings` ADD COLUMN `FedexKey` varchar(50) default NULL AFTER `FedexPassword`;

ALTER TABLE `multicart_artists` ADD COLUMN `storename` TEXT NULL AFTER `email`;

ALTER TABLE `multicart_artists` ADD COLUMN `theme_color` VARCHAR(50) NOT NULL AFTER `plan_expired`;

ALTER TABLE `multicart_artists` ADD COLUMN `theme_banner` VARCHAR(50) NOT NULL AFTER `theme_color`;

ALTER TABLE `multicart_artists` ADD COLUMN `theme_numrows` VARCHAR(255) NOT NULL AFTER `theme_banner`;

ALTER TABLE `multicart_artists` ADD COLUMN `theme_numcols` INT(10) NOT NULL AFTER `theme_numrows`;

ALTER TABLE `multicart_admin_menu` ADD COLUMN `title` TEXT NOT NULL DEFAULT '' AFTER `page_name`;

ALTER TABLE `multicart_helpcategory` CHANGE COLUMN `htype` `htype` VARCHAR(50) NULL DEFAULT NULL AFTER `hcid`;

ALTER TABLE `multicart_settings`
  ADD COLUMN `stripe_payment_enable` ENUM('Y','N') NOT NULL DEFAULT 'N' AFTER `dwolla_secretkey`,
  ADD COLUMN `stripe_payment_test_mode` ENUM('Y','N') NOT NULL DEFAULT 'N' AFTER `stripe_payment_enable`,
  ADD COLUMN `stripe_publish_key` VARCHAR(255) NULL DEFAULT NULL AFTER `stripe_payment_test_mode`,
  ADD COLUMN `stripe_secretkey` VARCHAR(255) NULL DEFAULT NULL AFTER `stripe_publish_key`;

ALTER TABLE `multicart_settings`
  ADD COLUMN `enable_free_shipping` ENUM('Y','N') NOT NULL DEFAULT 'N' AFTER `stripe_secretkey`,
  ADD COLUMN `min_order_amount` DOUBLE(11,2) NULL DEFAULT NULL AFTER `enable_free_shipping`;

ALTER TABLE `multicart_artists_membershipdetails` RENAME TO `multicart_artists_membershipDetails`;
ALTER TABLE `multicart_sellerplans` RENAME TO `multicart_sellerPlans`;
ALTER TABLE `multicart_review` RENAME TO `multicart_Review`;
  
DROP TABLE IF EXISTS `multicart_sections`;
CREATE TABLE `multicart_sections` (
  `section_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_name` varchar(100) NOT NULL,
  `avatar` varchar(250) DEFAULT NULL,
  `status` enum('Y','N') NOT NULL DEFAULT 'Y',
  `alias` varchar(100) DEFAULT NULL,
  `cdn_images_moved` enum('Y','N') DEFAULT 'N',
  PRIMARY KEY (`section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_section_category`;
CREATE TABLE `multicart_section_category` (
  `section_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`section_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_combo`;
CREATE TABLE `multicart_combo` (
  `combo_id` int(11) NOT NULL AUTO_INCREMENT,
  `combo_name` varchar(100) NOT NULL,
  `status` enum('Y','N') NOT NULL DEFAULT 'Y',
  `alias` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`combo_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_combo_products`;
CREATE TABLE `multicart_combo_products` (
  `combo_products_id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `combo_id` int NOT NULL,
  `products_id` int NOT NULL
) ENGINE='MyISAM' COLLATE 'utf8_general_ci';

ALTER TABLE `multicart_settings`
ADD COLUMN `enable_recommendation` CHAR(1) NOT NULL DEFAULT 'N' AFTER `enable_google`,
ADD COLUMN `recommendation_licence_value` TEXT NOT NULL AFTER `google_adsense_value`;

ALTER TABLE `multicart_settings`
ADD `enable_sectioncategory` varchar(10) COLLATE 'utf8_general_ci' NOT NULL DEFAULT 'N' AFTER `enable_bulkupload`;

ALTER TABLE `multicart_products`
ADD `product_section` text NULL AFTER `product_category`;

ALTER TABLE `multicart_combo`
ADD `quantity` int(11) NOT NULL AFTER `combo_name`;

ALTER TABLE `multicart_combo`
ADD `price` float NOT NULL AFTER `quantity`;

ALTER TABLE `multicart_combo`
ADD `avatar` varchar(250) COLLATE 'utf8_general_ci' NULL AFTER `price`,
ADD `cdn_images_moved` enum('Y','N') COLLATE 'utf8_general_ci' NULL DEFAULT 'N';

ALTER TABLE `multicart_combo_products`
CHANGE `products_id` `product_id` int(11) NOT NULL AFTER `combo_id`,
ADD `product_option_id` int(11) NOT NULL;

ALTER TABLE `multicart_combo_products`
ADD `product_quantity` int(11) NOT NULL DEFAULT '1' AFTER `product_option_id`;

ALTER TABLE `multicart_cart`
ADD COLUMN `combo_id` INT(11) NULL DEFAULT NULL AFTER `subscription_duration`;

ALTER TABLE `multicart_combo`
ADD COLUMN `seller_id` int(11) DEFAULT NULL;

ALTER TABLE `multicart_order_details`
ADD COLUMN `combo_id` int(11) DEFAULT NULL;

ALTER TABLE `multicart_combo`
ADD `combo_description` TEXT NOT NULL AFTER `combo_name`;

ALTER TABLE `multicart_settings`
ADD `cloudfront_cdn_url` varchar(255) NULL AFTER `enable_amazon_cdn_images`;

ALTER TABLE `multicart_settings`
ADD `enable_megamenu` varchar(100) DEFAULT 'N' NOT NULL ;

ALTER TABLE `multicart_settings`
ADD `enable_cookie` varchar(100) DEFAULT 'N' NOT NULL ;

ALTER TABLE `multicart_settings`  ADD `stripe_connect_payment_enable` ENUM('Y','N') NOT NULL DEFAULT 'N'  AFTER `enable_cookie`,  ADD `stripe_connect_publish_key` VARCHAR(255) NOT NULL  AFTER `stripe_connect_payment_enable`,  ADD `stripe_connect_secretkey` VARCHAR(255) NOT NULL  AFTER `stripe_connect_publish_key`,  ADD `stripe_connect_client_id` VARCHAR(255) NOT NULL  AFTER `stripe_connect_secretkey`;

ALTER TABLE `multicart_artists` ADD `stripe_user_id` VARCHAR(255) NOT NULL AFTER `ip_location`;