<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		          |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com (C) 2005              |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";

if (isset($_SESSION["sess_artistid"]) and $_SESSION["sess_artistid"] != "") {
    $artistid = $_SESSION["sess_artistid"];
} else {
    header("Location:login.php");
    exit;
}
if(checkArtistExpired($artistid)){
    header("Location:seller_plan_upgrade.php?sellerid=".$artistid);
    exit;
}


$maximagesizestringinPHP = ini_get("upload_max_filesize");
$maximagesizeinPHP = $maximagesizestringinPHP * (1024 * 1024);


if (isset($_POST['btnSave']) ) { // check button for save 
	
    $message = "";

    if (!isNotNull($_FILES['txtUploadZip']['name'])) {
        $message .= TEXT_UPLD_CSV;
    }
    $rdPublishStatus = $_POST['rdPublishStatus'];
    $sellerid = $artistid;
    if($rdPublishStatus=="N"){
        //published time in 24_hour_format
        $publishDate  = date("Y-m-d H:i:s", strtotime($_POST['publishdate'].$_POST['publishtime']));
        //Get seller time zone
      $arrSellerTimezone   = generalMethods::getSellerTimeZone($sellerid);
      $sellertimezone      = $arrSellerTimezone['seller_time_zone'];
    }else{
        $publishDate   = "";
        $sellertimezone = "";
    }       

    $uploadfile = ReplaceArrayImage($_FILES['txtUploadZip']['name']);
    $types = array('csv');
    preg_match('/\.([a-zA-Z]+?)$/', $uploadfile, $matches);
    if (!in_array(strtolower($matches[1]), $types)) { // check file format is valid or not 
        $message .= MSG_INVAL_CSV;
    } // end format check 

    if (!empty($_FILES['txtUploadZip']['name'])) { // moving files to folder
      
                        $tempFile = $_FILES['txtUploadZip']['tmp_name'];
                        $filename = $_FILES['txtUploadZip']['name'];
                        $file_extn = end(explode(".",$filename));
                        $filename = "csv_".rand().$file_extn;
			$tempFile=$_FILES['txtUploadZip']['tmp_name'];
			

        $destFolder = "../csv/" . $filename;

        if ($_FILES['txtUploadZip']['size'] > $maximagesizeinPHP) {
            $message.= MSG_SIZE_EXCEEDS.$maximagesizestringinPHP."<br>";
        }

        if (is_file($destFolder) && file_exists($destFolder)) {
            $message .= MSG_CSV_EXIST;
        } // end if file exists check 

        if ($message == '') {
            $file = move_uploaded_file($tempFile, $destFolder);
            if ($file) {                
                header("Location:mybulkupload_check.php?file=$filename&sellerid=$sellerid&publishstatus=$rdPublishStatus&publishtime=". urlencode($publishDate)."&sellertimezone=".  urlencode($sellertimezone));
            }
        }
    } // end if 
} // end if button check 

include "../includes/htmltop.php";
?>

<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
<script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
<link href="<?php echo SITE_URL; ?>/style/jquery.timepicker.css" rel="stylesheet" type="text/css">
<link rel="stylesheet" href="<?php echo SITE_URL; ?>/style/dateselector.css" type="text/css" />
<link href="http://www.jqueryscript.net/css/jquerysctipttop.css" rel="stylesheet" type="text/css">	

<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/jquery.timepicker.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/dateselector.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/dateselector.min.js"></script>
<script language="JavaScript" type="text/JavaScript">
    $(document).ready(function(){
        $('.rdPublishStatus').click(function(){

            if($('input[name=rdPublishStatus]:checked').val()=="N"){            
                $("#publish_time").show();            
            }else if($('input[name=rdPublishStatus]:checked').val()=="Y"){
                $("#publish_time").hide();            
            }

        });    

        $("#publishtime").timepicker(); 
        //$("#publishdate" ).dateSelector();
       var dateToday = new Date(Date.now());
       $("#publishdate").datepicker({          
           minDate: dateToday
       }).datepicker('setDate', dateToday)
       
    });

    function clickSearch()
    {

        document.frmProductBulkImages.submit();	
 
    }

    function blockImages(val)
    {


        if(val == 'N')
        {

            return confirm('<?php echo MSG_DIS_BULK_IMG;?>!!')
	
        }
        else if(val == 'Y')
        {
	
            return confirm('<?php echo MSG_EN_BULK_IMG;?> !!')
	
        }	
	

    }

    function deleteImages()
    {
			
        return confirm('<?php echo MSG_DEL_BULK_IMG?> !!')
    }

</script>

<body>

<center>

    <div align="left" id="layout">




        <!--header area start -->
<?php
include_once("../includes/topheader_seller.php");
?>

        <!--header area end -->




        <div align="left" class="main_body">
            <!--main body start -->



        <?php
        include_once("../includes/artisttopmenu.php")
        ?>		


            <div align="left" class="content_area">

                <!--content area start -->

                <div align="left" class="page_title"><?php echo TEXT_BULK_PROD_UPLOAD;?></div>
                <div align="center" class="text_information grey_tr"><?php echo $message ?></div>
                <br>

                <div align="left">		
                    <table>
                        <tr><td height="35"><?php //include_once("../includes/imagemenu.php")?></td>
                        </tr></table>																	
                    <form action="" method="post" enctype="multipart/form-data" name="frmbulkupload">

                        <table width="98%" border="0" cellpadding="0" cellspacing="0" class="manage_table">

                            <tr>
                                <td colspan="3"><?php echo TEXT_MAX_UPLD_SIZE;?>: <b><?php echo $maximagesizestringinPHP; ?></b></td>
                            </tr>
                            <tr>
                                <td height="33" colspan="3"><h4><?php echo MSG_CSV_FILE;?> <a href="../includes/download.php?f=../csv/sample.csv" class="csvlink"> Sample.CSV </a> <?php echo MSG_AND_KEEP_HEAD;?>. </h4></td>
                            </tr>
                            <tr>
                                <td height="33" colspan="3"><b><i><?php echo TEXT_NOTE;?> : </i></b> <?php echo MSG_CSV_FILE1;?>.</td>
                            </tr>
                            
                             <tr>
                                <td height="20" colspan="3"><b><i><?php echo TEXT_NOTE;?> : </i></b> <?php echo MSG_SMAILL_IMAGE_SIZE;?>.</td>
                            </tr>
                             <tr>
                                <td height="20" colspan="3"><b><i><?php echo TEXT_NOTE;?> : </i></b> <?php echo MSG_BIG_IMAGE_SIZE;?>.</td>
                            </tr>
                            <tr>
                                <td align="right"><?php echo TEXT_PUBLISH_STATUS; ?>&nbsp;</td>
                                <td>:</td>
                                <td align='left'>
                                    <input type="radio" name="rdPublishStatus" class="rdPublishStatus" value="Y" <?php if ($rdPublishStatus  == "Y") {   echo "checked"; } elseif($rdPublishStatus==NULL){echo "checked";}?>><?php echo TEXT_PUBLISH_NOW;?>                                   
                                    <input type="radio" name="rdPublishStatus" class="rdPublishStatus" value="N" <?php if ($rdPublishStatus  == "N") {   echo "checked"; }?>><?php echo TEXT_PUBLISH_LATER;?>
                                    <span class="help"><a href="#" title="<?php echo PUBLISH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                </td>
                            </tr>
                            <tr id="publish_time" style="display: none;">
                                <td align="right"><?php echo TEXT_PUBLISH_DATE; ?>&nbsp;</td>
                                <td>:</td>
                                <td align='left'><table><tr><td><input type="text" id="publishdate" name="publishdate"></td>
                                            <td><?php echo TEXT_PUBLISH_TIME; ?></td>
                                            <td><input type="text" id="publishtime" name="publishtime" style="width: 54px;"></td>
                                            <td><span class="help"><a href="#" title="<?php echo TEXT_PUBLISH_TIME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></td>
                                        </tr>                                                                        
                                    </table>                                                                        
                                </td>
                            </tr>   
                            <tr>
                                <td align="right"><?php echo TEXT_UPLD_CSV;?></td>
                                <td>&nbsp;</td>
                                <td><input name="txtUploadZip" type="file" id="txtUploadZip"></td>
                            </tr>
                            <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                            </tr>
                            <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                            </tr>
                            <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td><input type="submit" name="btnSave" value="<?php echo BTN_NEXT;?>" class="button"></td>
                            </tr>
                        </table>

                    </form>


                </div>


                <!--content area end-->

            </div>


            <div align="left" class="clear_float"><img src="<?php echo $imagefolder; ?>/clear.gif" alt="" width="1" height="1" /></div>
            <!--main body end -->
        </div>


<?php
include "../includes/footer.php";
?>
        <script language="javascript">

            function valiadtion()

            {
                if(document.frmbulkupload.txtBulkUpload.value=="")
                {
		
                    alert("Please Upload Your file");
                    document.frmbulkupload.txtBulkUpload.focus();
                    return false;
		
                }
                if(document.frmbulkupload.seller.value=="")
                {
		
                    alert("Please select a seller");
                    document.frmbulkupload.seller.focus();
                    return false;
		
                }
		
		
                else
                {
		
                    return true;
		
                }	

            }

        </script>